/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.importExcel;

import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.importExcel.ErrorMessage;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumnNumber;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

@Component(value="parseExcelComponent")
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class ParseExcelComponent<T> {
    private Class<T> clazz;
    private InputStream is;
    private List<ObjectError> errorMessages = new ArrayList<ObjectError>();
    private List<String> warnMessages = new ArrayList<String>();
    private Set<String> headerColumn = new HashSet<String>();
    private Map<Integer, Field> columnMap = new HashMap<Integer, Field>();
    private Map<String, String> fieldNameMap = new HashMap<String, String>();
    private List<T> availableResults = new ArrayList<T>();
    private List<T> allResults = new ArrayList<T>();
    private List<T> failureResults = new ArrayList<T>();
    private Method setErrorMsgMethod;
    private Method getErrorMsgMethod;
    private Method setColumnNumberMethod;
    @Autowired
    private Validator beanVidator;
    @Autowired
    private ConversionService myConversionService;

    public void parse(InputStream is, Class<T> clazz) {
        this.is = is;
        this.clazz = clazz;
        this.validateExcel();
    }

    public void parse(File file, Class<T> clazz) {
        if (file == null) {
            throw new IllegalArgumentException("the file is null!");
        }
        try {
            this.is = new FileInputStream(file);
            this.clazz = clazz;
            this.validateExcel();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void parse(String fileName, Class<T> clazz) {
        if (fileName == null || fileName.trim().length() < 1) {
            throw new IllegalArgumentException("the file path is empty");
        }
        File file = new File(fileName);
        try {
            this.is = new FileInputStream(file);
            this.clazz = clazz;
            this.validateExcel();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public List<T> getAvailableResults() {
        return this.availableResults;
    }

    public List<ObjectError> getErrorMessages() {
        return this.errorMessages;
    }

    public String getErrorInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.errorMessages != null && this.errorMessages.size() > 0) {
            for (ObjectError error : this.errorMessages) {
                stringBuffer.append(error.getDefaultMessage());
                stringBuffer.append("</br>");
            }
        }
        return stringBuffer.toString();
    }

    public List<T> getFailureResults() {
        return this.failureResults;
    }

    public List<T> getAllResults() {
        return this.allResults;
    }

    public boolean hasErrors() {
        return this.errorMessages.size() > 0;
    }

    public List<String> getWarnMessages() {
        return this.warnMessages;
    }

    public boolean hasWarns() {
        return this.warnMessages.size() > 0;
    }

    private void validateExcel() {
        ExcelTemplate et = this.clazz.getAnnotation(ExcelTemplate.class);
        if (et == null) {
            throw new RuntimeException("the class is not a excel template data");
        }
        try {
            WorkbookSettings workbooksetting = new WorkbookSettings();
            workbooksetting.setCellValidationDisabled(true);
            Workbook wb = Workbook.getWorkbook((InputStream)this.is, (WorkbookSettings)workbooksetting);
            Sheet sheet = wb.getSheet(0);
            if (sheet.getRows() <= 1) {
                this.errorMessages.add(new ObjectError(this.clazz.getName(), "Excel\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u683c\u5f0f\u751f\u6210excel\u6587\u4ef6!"));
                return;
            }
            Cell[] firstRow = sheet.getRow(0);
            if (firstRow.length < 1) {
                this.errorMessages.add(new ObjectError(this.clazz.getName(), "Excel\u6587\u4ef6\u6ca1\u6709\u7b2c\u4e00\u884c\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u683c\u5f0f\u751f\u6210excel\u6587\u4ef6!"));
                return;
            }
            this.checkExcelHeader(firstRow);
            if (this.errorMessages.size() > 0) {
                return;
            }
            if (this.headerColumn.size() < 1) {
                this.errorMessages.add(new ObjectError(this.clazz.getName(), "Excel\u6587\u4ef6\u7b2c\u4e00\u884c\u7684\u5217\u540d\u4e0e\u6a21\u677f\u5b8c\u5168\u4e0d\u7b26,\u8bf7\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u683c\u5f0f\u751f\u6210excel\u6587\u4ef6!"));
                return;
            }
            this.initErrorMessageAndColumnNumberMehtod();
            this.convertToJavaBean(sheet);
            int rowTip = 1;
            for (T t : this.allResults) {
                this.validate(t, rowTip);
                ++rowTip;
            }
            this.checkUniqueConstrain();
        }
        catch (BiffException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void checkExcelHeader(Cell[] firstRowCells) {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Class<T> temp = this.clazz; temp != null && !temp.equals(Object.class) && temp.getAnnotation(ExcelTemplate.class) != null; temp = temp.getSuperclass()) {
            Field[] fs = temp.getDeclaredFields();
            for (int x = 0; x < fs.length; ++x) {
                ExcelColumn ec = fs[x].getAnnotation(ExcelColumn.class);
                if (ec == null) continue;
                fieldsList.add(fs[x]);
            }
        }
        for (int i = 0; i < firstRowCells.length; ++i) {
            String content = firstRowCells[i].getContents();
            if (content == null || content.trim().length() < 1) continue;
            content = content.trim();
            for (int j = 0; j < fieldsList.size(); ++j) {
                ExcelColumn ec = ((Field)fieldsList.get(j)).getAnnotation(ExcelColumn.class);
                if (ec == null) continue;
                String columnName = ec.name().equals("") ? ((Field)fieldsList.get(j)).getName() : ec.name();
                this.fieldNameMap.put(((Field)fieldsList.get(j)).getName(), ec.name());
                if (!content.equals(columnName)) continue;
                if (!this.headerColumn.add(columnName)) {
                    this.errorMessages.add(new ObjectError(this.clazz.getName(), "\u5728\u6a21\u677f\u4e2d\u53d1\u73b0\u6709\u91cd\u590d\u7684\u5217\u540d" + columnName));
                    continue;
                }
                this.columnMap.put(i, (Field)fieldsList.get(j));
            }
        }
    }

    private void convertToJavaBean(Sheet sheet) {
        try {
            int row = sheet.getRows();
            for (int i = 1; i < row; ++i) {
                T obj = this.clazz.newInstance();
                Cell[] cells = sheet.getRow(i);
                int nullCount = 0;
                for (Integer j : this.columnMap.keySet()) {
                    Field field = this.columnMap.get(j);
                    if (field == null) {
                        ++nullCount;
                        continue;
                    }
                    if (j < cells.length) {
                        String chineseName;
                        String string = chineseName = this.fieldNameMap.get(field.getName()).length() < 1 ? field.getName() : this.fieldNameMap.get(field.getName());
                        if (CellType.EMPTY.equals(cells[j].getType()) || CellType.ERROR.equals(cells[j].getType())) {
                            ++nullCount;
                            continue;
                        }
                        String content = cells[j].getContents().trim();
                        if (content.length() > 0) {
                            Method method = this.clazz.getMethod(this.generateSetMethod(field.getName()), field.getType());
                            if (!String.class.getName().equals(field.getType().getName())) {
                                try {
                                    if (Date.class.getName().equals(field.getType().getName())) {
                                        CellType cellTypes = cells[j].getType();
                                        String type = cellTypes.toString();
                                        TimeZone zone = TimeZone.getTimeZone("GMT");
                                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                        sdf.setTimeZone(zone);
                                        if (type.equalsIgnoreCase("DATE")) {
                                            DateCell dc = (DateCell)cells[j];
                                            String context = sdf.format(dc.getDate());
                                            TimeZone local = TimeZone.getDefault();
                                            sdf.setTimeZone(local);
                                            Date date = sdf.parse(context);
                                            method.invoke(obj, date);
                                            continue;
                                        }
                                        Date date = DateUtil.parse(content, "yyyy-MM-dd HH:mm:ss");
                                        if (date == null) {
                                            date = DateUtil.parse(content, "yyyy-MM-dd");
                                        }
                                        if (date == null) {
                                            date = DateUtil.parse(content, "yyyy/MM/dd");
                                        }
                                        method.invoke(obj, date);
                                        continue;
                                    }
                                    method.invoke(obj, this.myConversionService.convert((Object)content, field.getType()));
                                }
                                catch (Exception e) {
                                    this.warnMessages.add("\u7b2c" + (i + 1) + "\u884c\u4e2d," + chineseName + "\u683c\u5f0f\u4e0d\u6b63\u786e");
                                    this.errorMessages.add((ObjectError)new FieldError(this.clazz.getName(), field.getName(), "\u7b2c" + i + "\u884c\u4e2d," + chineseName + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
                                }
                                continue;
                            }
                            method.invoke(obj, content);
                            continue;
                        }
                        ++nullCount;
                        continue;
                    }
                    ++nullCount;
                }
                if (this.columnMap.size() <= nullCount) continue;
                this.setExcelColumnNumber(obj, i + 1);
                this.allResults.add(obj);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void validate(T obj, int row) {
        BindException errors = new BindException(obj, this.clazz.getSimpleName());
        this.beanVidator.validate(obj, (Errors)errors);
        if (errors.hasErrors()) {
            for (FieldError error : errors.getFieldErrors()) {
                if (this.fieldNameMap.get(error.getField()) == null) continue;
                String chineseName = this.fieldNameMap.get(error.getField()).length() < 1 ? error.getField() : this.fieldNameMap.get(error.getField());
                this.errorMessages.add((ObjectError)new FieldError(error.getObjectName(), error.getField(), "\u7b2c" + (row + 1) + "\u884c\u4e2d," + chineseName + error.getDefaultMessage()));
                this.setErrorMessage(obj, chineseName + error.getDefaultMessage());
            }
            this.failureResults.add(obj);
        } else {
            this.availableResults.add(obj);
        }
    }

    private void checkUniqueConstrain() {
        HashSet<Field> fields = new HashSet<Field>();
        for (int i : this.columnMap.keySet()) {
            Field field = this.columnMap.get(i);
            ExcelColumn ec = field.getAnnotation(ExcelColumn.class);
            if (ec == null || !ec.unique()) continue;
            fields.add(field);
        }
        if (fields.size() < 1) {
            return;
        }
        try {
            ArrayList<T> needToRemove = new ArrayList<T>();
            for (Field f : fields) {
                Method method = this.clazz.getMethod(this.generateGetMethod(f.getName()), new Class[0]);
                for (int i = 0; i < this.availableResults.size(); ++i) {
                    T t = this.availableResults.get(i);
                    Object obj = method.invoke(t, new Object[0]);
                    int rowDis = 2;
                    boolean hasIt = false;
                    String chineseName = this.fieldNameMap.get(f.getName()).length() < 1 ? f.getName() : this.fieldNameMap.get(f.getName());
                    for (int j = 0; j < this.availableResults.size(); ++j) {
                        T sub = this.availableResults.get(j);
                        if (j == i || needToRemove.contains(sub)) continue;
                        Object sobj = method.invoke(sub, new Object[0]);
                        if (obj == null || !obj.equals(sobj)) continue;
                        this.errorMessages.add((ObjectError)new FieldError(this.clazz.getName(), "multiple_" + f.getName(), "\u7b2c" + (i + rowDis) + "\u884c\u548c\u7b2c" + (j + rowDis) + "\u884c\u4e2d\u7684" + chineseName + "\u6570\u636e\u91cd\u590d!"));
                        this.setErrorMessage(sub, chineseName + "\u6570\u636e\u91cd\u590d!");
                        needToRemove.add(sub);
                        hasIt = true;
                    }
                    if (!hasIt) continue;
                    needToRemove.add(t);
                    this.setErrorMessage(t, chineseName + "\u6570\u636e\u91cd\u590d!");
                }
                if (needToRemove.size() > 0) {
                    this.availableResults.removeAll(needToRemove);
                    this.failureResults.addAll(needToRemove);
                }
                needToRemove.clear();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void initErrorMessageAndColumnNumberMehtod() {
        Field[] fields = this.clazz.getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                ErrorMessage em = fields[i].getAnnotation(ErrorMessage.class);
                ExcelColumnNumber ecn = fields[i].getAnnotation(ExcelColumnNumber.class);
                if (em != null && this.setErrorMsgMethod == null) {
                    this.setErrorMsgMethod = this.clazz.getMethod(this.generateSetMethod(fields[i].getName()), fields[i].getType());
                    this.getErrorMsgMethod = this.clazz.getMethod(this.generateGetMethod(fields[i].getName()), new Class[0]);
                }
                if (ecn == null || this.setColumnNumberMethod != null) continue;
                this.setColumnNumberMethod = this.clazz.getMethod(this.generateSetMethod(fields[i].getName()), fields[i].getType());
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private void setExcelColumnNumber(T obj, Integer number) {
        if (this.setColumnNumberMethod != null) {
            try {
                this.setColumnNumberMethod.invoke(obj, number);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void setErrorMessage(T obj, String message) {
        if (this.setErrorMsgMethod != null) {
            try {
                String em = this.getErrorMessage(obj);
                if (em != null && em.trim().length() > 0) {
                    this.setErrorMsgMethod.invoke(obj, em + ";" + message);
                } else {
                    this.setErrorMsgMethod.invoke(obj, message);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private String getErrorMessage(T obj) {
        if (this.getErrorMsgMethod != null) {
            try {
                return (String)this.getErrorMsgMethod.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String generateSetMethod(String fieldName) {
        if (fieldName == null || fieldName.length() < 1) {
            return "";
        }
        return "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
    }

    private String generateGetMethod(String fieldName) {
        if (fieldName == null || fieldName.length() < 1) {
            return "";
        }
        return "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
    }

    public static void main(String[] args) {
    }
}

