/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.importExcel;

import com.thebeastshop.pegasus.util.importExcel.ErrorMessage;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumnList;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumnNumber;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jxl.Cell;
import jxl.DateCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

@Component(value="advancedParseExcelComponent")
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class AdvancedParseExcelComponent {
    @Autowired
    protected Validator beanVidator;
    @Autowired
    protected ConversionService myConversionService;

    public <T> Parser<T> parse(InputStream is, Class<T> clazz) {
        Parser<T> parser = new Parser<T>();
        parser.parse(is, clazz);
        return parser;
    }

    public <T> Parser<T> parse(File file, Class<T> clazz) {
        Parser<T> parser = new Parser<T>();
        parser.parse(file, clazz);
        return parser;
    }

    public <T> Parser<T> parse(String fileName, Class<T> clazz) {
        Parser<T> parser = new Parser<T>();
        parser.parse(fileName, clazz);
        return parser;
    }

    public class Parser<T> {
        protected Class<T> clazz;
        protected InputStream is;
        protected List<ObjectError> errorMessages = new ArrayList<ObjectError>();
        protected List<String> warnMessages = new ArrayList<String>();
        protected Set<String> headerColumn = new HashSet<String>();
        protected Map<Integer, Field> columnMap = new HashMap<Integer, Field>();
        protected Map<String, String> fieldNameMap = new HashMap<String, String>();
        private Map<String, FieldReader> fieldReaderMap = new HashedMap();
        protected List<T> availableResults = new ArrayList<T>();
        protected List<T> allResults = new ArrayList<T>();
        protected List<T> failureResults = new ArrayList<T>();
        protected Method setErrorMsgMethod;
        protected Method getErrorMsgMethod;
        private Method setColumnNumberMethod;

        public void parse(InputStream is, Class<T> clazz) {
            this.is = is;
            this.clazz = clazz;
            this.validateExcel();
        }

        public void parse(File file, Class<T> clazz) {
            if (file == null) {
                throw new IllegalArgumentException("the file is null!");
            }
            try {
                this.is = new FileInputStream(file);
                this.clazz = clazz;
                this.validateExcel();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }

        public void parse(String fileName, Class<T> clazz) {
            if (fileName == null || fileName.trim().length() < 1) {
                throw new IllegalArgumentException("the file path is empty");
            }
            File file = new File(fileName);
            try {
                this.is = new FileInputStream(file);
                this.clazz = clazz;
                this.validateExcel();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }

        public List<T> getAvailableResults() {
            return this.availableResults;
        }

        public List<ObjectError> getErrorMessages() {
            return this.errorMessages;
        }

        public String getErrorInfo() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.errorMessages != null && this.errorMessages.size() > 0) {
                for (ObjectError error : this.errorMessages) {
                    stringBuffer.append(error.getDefaultMessage());
                    stringBuffer.append("</br>");
                }
            }
            return stringBuffer.toString();
        }

        public List<T> getFailureResults() {
            return this.failureResults;
        }

        public List<T> getAllResults() {
            return this.allResults;
        }

        public boolean hasErrors() {
            return this.errorMessages.size() > 0;
        }

        public List<String> getWarnMessages() {
            return this.warnMessages;
        }

        public boolean hasWarns() {
            return this.warnMessages.size() > 0;
        }

        protected Sheet getSheet(Workbook wb) {
            ExcelSheet st = this.clazz.getAnnotation(ExcelSheet.class);
            String sheetName = st.value();
            if (StringUtils.isNotEmpty((String)sheetName)) {
                return wb.getSheet(sheetName);
            }
            int index = st.index();
            return wb.getSheet(index);
        }

        private void validateExcel() {
            ExcelTemplate et = this.clazz.getAnnotation(ExcelTemplate.class);
            if (et == null) {
                throw new RuntimeException("the class is not a excel template data");
            }
            try {
                WorkbookSettings workbooksetting = new WorkbookSettings();
                workbooksetting.setCellValidationDisabled(true);
                Workbook wb = Workbook.getWorkbook((InputStream)this.is, (WorkbookSettings)workbooksetting);
                Sheet sheet = this.getSheet(wb);
                if (sheet == null || sheet.getRows() <= 1) {
                    this.errorMessages.add(new ObjectError(this.clazz.getName(), "Excel\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u683c\u5f0f\u751f\u6210excel\u6587\u4ef6!"));
                    return;
                }
                Cell[] firstRow = sheet.getRow(0);
                if (firstRow.length < 1) {
                    this.errorMessages.add(new ObjectError(this.clazz.getName(), "Excel\u6587\u4ef6\u6ca1\u6709\u7b2c\u4e00\u884c\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u683c\u5f0f\u751f\u6210excel\u6587\u4ef6!"));
                    return;
                }
                this.checkExcelHeader(firstRow);
                if (this.errorMessages.size() > 0) {
                    return;
                }
                if (this.fieldReaderMap.keySet().size() < 1) {
                    this.errorMessages.add(new ObjectError(this.clazz.getName(), "Excel\u6587\u4ef6\u7b2c\u4e00\u884c\u7684\u5217\u540d\u4e0e\u6a21\u677f\u5b8c\u5168\u4e0d\u7b26,\u8bf7\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u683c\u5f0f\u751f\u6210excel\u6587\u4ef6!"));
                    return;
                }
                this.initErrorMessageAndColumnNumberMehtod();
                this.convertToJavaBean(sheet);
                int rowTip = 1;
                for (T t : this.allResults) {
                    this.validate(t, rowTip);
                    ++rowTip;
                }
                this.checkUniqueConstrain();
            }
            catch (BiffException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }

        protected void checkExcelHeader(Cell[] firstRowCells) {
            ArrayList<Field> fieldsList = new ArrayList<Field>();
            for (Class<T> temp = this.clazz; temp != null && !temp.equals(Object.class) && temp.getAnnotation(ExcelTemplate.class) != null; temp = temp.getSuperclass()) {
                Field[] fs = temp.getDeclaredFields();
                for (int x = 0; x < fs.length; ++x) {
                    Field f = fs[x];
                    ExcelColumn ec = f.getAnnotation(ExcelColumn.class);
                    ExcelColumnList ecl = f.getAnnotation(ExcelColumnList.class);
                    if (ec == null && ecl == null) continue;
                    fieldsList.add(f);
                }
            }
            for (int i = 0; i < firstRowCells.length; ++i) {
                String content = firstRowCells[i].getContents();
                if (content == null || content.trim().length() < 1) continue;
                content = content.trim();
                for (int j = 0; j < fieldsList.size(); ++j) {
                    Field f = (Field)fieldsList.get(j);
                    ExcelColumn ec = f.getAnnotation(ExcelColumn.class);
                    ExcelColumnList ecl = f.getAnnotation(ExcelColumnList.class);
                    if (ec == null && ecl == null) continue;
                    FieldReader fieldReader = null;
                    if (ecl != null) {
                        int from = ecl.from();
                        int to = ecl.to();
                        if (i < from || to >= 0 && i > to || to < 0 && i > firstRowCells.length + to) continue;
                        fieldReader = new ListFieldReader();
                        ListFieldReader listFieldReader = (ListFieldReader)fieldReader;
                        listFieldReader.setFrom(ecl.from());
                        listFieldReader.setTo(ecl.to());
                        listFieldReader.setItemClass(ecl.type());
                        listFieldReader.setColumnFieldName(ecl.columnFiled());
                        listFieldReader.setValueFieldName(ecl.valueField());
                        this.columnMap.put(i, (Field)fieldsList.get(j));
                        this.fieldNameMap.put(((Field)fieldsList.get(j)).getName(), content);
                    } else {
                        fieldReader = new FieldReader();
                        String columnName = ec.name().equals("") ? ((Field)fieldsList.get(j)).getName() : ec.name();
                        this.fieldNameMap.put(((Field)fieldsList.get(j)).getName(), ec.name());
                        if (content.equals(columnName)) {
                            if (!this.headerColumn.add(columnName)) {
                                this.errorMessages.add(new ObjectError(this.clazz.getName(), "\u5728\u6a21\u677f\u4e2d\u53d1\u73b0\u6709\u91cd\u590d\u7684\u5217\u540d" + columnName));
                            } else {
                                this.columnMap.put(i, (Field)fieldsList.get(j));
                            }
                        }
                    }
                    fieldReader.setField(f);
                    fieldReader.setIndex(i);
                    this.fieldReaderMap.put(f.getName(), fieldReader);
                }
            }
        }

        private Class classFromType(Type type, int i) {
            if (type instanceof ParameterizedType) {
                return this.getGenericClass((ParameterizedType)type, i);
            }
            if (type instanceof TypeVariable) {
                return this.classFromType(((TypeVariable)type).getBounds()[0], 0);
            }
            return (Class)type;
        }

        private Class getGenericClass(ParameterizedType parameterizedType, int i) {
            Type genericClass = parameterizedType.getActualTypeArguments()[i];
            if (genericClass instanceof ParameterizedType) {
                return (Class)((ParameterizedType)genericClass).getRawType();
            }
            if (genericClass instanceof GenericArrayType) {
                return (Class)((GenericArrayType)genericClass).getGenericComponentType();
            }
            if (genericClass instanceof TypeVariable) {
                return this.classFromType(((TypeVariable)genericClass).getBounds()[0], 0);
            }
            return (Class)genericClass;
        }

        protected void convertToJavaBean(Sheet sheet) {
            try {
                int row = sheet.getRows();
                for (int i = 1; i < row; ++i) {
                    Cell[] cells = sheet.getRow(i);
                    RowReader<T> rowReader = new RowReader<T>();
                    rowReader.setRowNumber(i);
                    rowReader.setInstance(this.clazz.newInstance());
                    rowReader.setNullCount(0);
                    for (Integer j : this.columnMap.keySet()) {
                        Field field = this.columnMap.get(j);
                        if (field == null) {
                            rowReader.incNullCount();
                            continue;
                        }
                        if (j < cells.length) {
                            Cell[] firstRow = sheet.getRow(0);
                            String chineseName = firstRow[j].getContents();
                            FieldReader fieldReader = this.fieldReaderMap.get(field.getName());
                            fieldReader.setChineseName(chineseName);
                            Cell cell = cells[j];
                            Object object = fieldReader.read(cell, rowReader);
                            continue;
                        }
                        rowReader.incNullCount();
                    }
                    if (this.columnMap.size() <= rowReader.getNullCount()) continue;
                    this.setExcelColumnNumber(rowReader.getInstance(), i + 1);
                    this.allResults.add(rowReader.getInstance());
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        protected void validate(T obj, int row) {
            BindException errors = new BindException(obj, this.clazz.getSimpleName());
            AdvancedParseExcelComponent.this.beanVidator.validate(obj, (Errors)errors);
            if (errors.hasErrors()) {
                for (FieldError error : errors.getFieldErrors()) {
                    if (this.fieldNameMap.get(error.getField()) == null) continue;
                    String chineseName = this.fieldNameMap.get(error.getField()).length() < 1 ? error.getField() : this.fieldNameMap.get(error.getField());
                    this.errorMessages.add((ObjectError)new FieldError(error.getObjectName(), error.getField(), "\u7b2c" + (row + 1) + "\u884c\u4e2d," + chineseName + error.getDefaultMessage()));
                    this.setErrorMessage(obj, chineseName + error.getDefaultMessage());
                }
                this.failureResults.add(obj);
            } else {
                this.availableResults.add(obj);
            }
        }

        protected void checkUniqueConstrain() {
            HashSet<Field> fields = new HashSet<Field>();
            for (int i : this.columnMap.keySet()) {
                Field field = this.columnMap.get(i);
                ExcelColumn ec = field.getAnnotation(ExcelColumn.class);
                if (ec == null || !ec.unique()) continue;
                fields.add(field);
            }
            if (fields.size() < 1) {
                return;
            }
            try {
                ArrayList<T> needToRemove = new ArrayList<T>();
                for (Field f : fields) {
                    Method method = this.clazz.getMethod(this.generateGetMethod(f.getName()), new Class[0]);
                    for (int i = 0; i < this.availableResults.size(); ++i) {
                        T t = this.availableResults.get(i);
                        Object obj = method.invoke(t, new Object[0]);
                        int rowDis = 2;
                        boolean hasIt = false;
                        String chineseName = this.fieldNameMap.get(f.getName()).length() < 1 ? f.getName() : this.fieldNameMap.get(f.getName());
                        for (int j = 0; j < this.availableResults.size(); ++j) {
                            T sub = this.availableResults.get(j);
                            if (j == i || needToRemove.contains(sub)) continue;
                            Object sobj = method.invoke(sub, new Object[0]);
                            if (obj == null || !obj.equals(sobj)) continue;
                            this.errorMessages.add((ObjectError)new FieldError(this.clazz.getName(), "multiple_" + f.getName(), "\u7b2c" + (i + rowDis) + "\u884c\u548c\u7b2c" + (j + rowDis) + "\u884c\u4e2d\u7684" + chineseName + "\u6570\u636e\u91cd\u590d!"));
                            this.setErrorMessage(sub, chineseName + "\u6570\u636e\u91cd\u590d!");
                            needToRemove.add(sub);
                            hasIt = true;
                        }
                        if (!hasIt) continue;
                        needToRemove.add(t);
                        this.setErrorMessage(t, chineseName + "\u6570\u636e\u91cd\u590d!");
                    }
                    if (needToRemove.size() > 0) {
                        this.availableResults.removeAll(needToRemove);
                        this.failureResults.addAll(needToRemove);
                    }
                    needToRemove.clear();
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        protected void initErrorMessageAndColumnNumberMehtod() {
            Field[] fields = this.clazz.getDeclaredFields();
            try {
                for (int i = 0; i < fields.length; ++i) {
                    ErrorMessage em = fields[i].getAnnotation(ErrorMessage.class);
                    ExcelColumnNumber ecn = fields[i].getAnnotation(ExcelColumnNumber.class);
                    if (em != null && this.setErrorMsgMethod == null) {
                        this.setErrorMsgMethod = this.clazz.getMethod(this.generateSetMethod(fields[i].getName()), fields[i].getType());
                        this.getErrorMsgMethod = this.clazz.getMethod(this.generateGetMethod(fields[i].getName()), new Class[0]);
                    }
                    if (ecn == null || this.setColumnNumberMethod != null) continue;
                    this.setColumnNumberMethod = this.clazz.getMethod(this.generateSetMethod(fields[i].getName()), fields[i].getType());
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }

        private void setExcelColumnNumber(T obj, Integer number) {
            if (this.setColumnNumberMethod != null) {
                try {
                    this.setColumnNumberMethod.invoke(obj, number);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        private void setErrorMessage(T obj, String message) {
            if (this.setErrorMsgMethod != null) {
                try {
                    String em = this.getErrorMessage(obj);
                    if (em != null && em.trim().length() > 0) {
                        this.setErrorMsgMethod.invoke(obj, em + ";" + message);
                    } else {
                        this.setErrorMsgMethod.invoke(obj, message);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        private String getErrorMessage(T obj) {
            if (this.getErrorMsgMethod != null) {
                try {
                    return (String)this.getErrorMsgMethod.invoke(obj, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        private String generateSetMethod(String fieldName) {
            if (fieldName == null || fieldName.length() < 1) {
                return "";
            }
            return "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        }

        private String generateGetMethod(String fieldName) {
            if (fieldName == null || fieldName.length() < 1) {
                return "";
            }
            return "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        }

        private class RowReader<T> {
            private int rowNumber = 0;
            private T instance;
            private int nullCount = 0;

            private RowReader() {
            }

            public int getRowNumber() {
                return this.rowNumber;
            }

            public void setRowNumber(int rowNumber) {
                this.rowNumber = rowNumber;
            }

            public T getInstance() {
                return this.instance;
            }

            public void setInstance(T instance) {
                this.instance = instance;
            }

            public int getNullCount() {
                return this.nullCount;
            }

            public void setNullCount(int nullCount) {
                this.nullCount = nullCount;
            }

            public int incNullCount() {
                ++this.nullCount;
                return this.nullCount;
            }
        }

        private class ListFieldReader
        extends FieldReader {
            private int from;
            private int to;
            private Class itemClass;
            private String columnFieldName;
            private String valueFieldName;

            private ListFieldReader() {
                this.from = 0;
                this.to = -1;
            }

            @Override
            public Object read(Cell cell, RowReader<T> rowReader) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, InstantiationException {
                String content = cell.getContents().trim();
                Object instance = rowReader.getInstance();
                ArrayList value = null;
                if (content.length() > 0) {
                    Class<?> fieldType = this.field.getType();
                    Method getter = Parser.this.clazz.getMethod(Parser.this.generateGetMethod(this.field.getName()), new Class[0]);
                    value = (ArrayList)getter.invoke(instance, new Object[0]);
                    Method setter = Parser.this.clazz.getMethod(Parser.this.generateSetMethod(this.field.getName()), this.field.getType());
                    if (value == null) {
                        value = new ArrayList();
                        setter.invoke(instance, value);
                    }
                    Integer num = null;
                    try {
                        num = Integer.parseInt(content);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num != null) {
                        Object itemObj;
                        if (this.itemClass.equals(Object.class)) {
                            this.itemClass = Parser.this.classFromType(fieldType.getGenericInterfaces()[0], 0);
                        }
                        if ((itemObj = this.itemClass.newInstance()) != null) {
                            Field columnField = this.itemClass.getDeclaredField(this.columnFieldName);
                            Field valueField = this.itemClass.getDeclaredField(this.valueFieldName);
                            String columnSetterName = Parser.this.generateSetMethod(columnField.getName());
                            String valueSetterName = Parser.this.generateSetMethod(valueField.getName());
                            Method columnSetter = this.itemClass.getDeclaredMethod(columnSetterName, columnField.getType());
                            Method valueSetter = this.itemClass.getDeclaredMethod(valueSetterName, valueField.getType());
                            columnSetter.invoke(itemObj, this.chineseName);
                            valueSetter.invoke(itemObj, num);
                            value.add(itemObj);
                        }
                    }
                }
                return value;
            }

            public String getColumnFieldName() {
                return this.columnFieldName;
            }

            public void setColumnFieldName(String columnFieldName) {
                this.columnFieldName = columnFieldName;
            }

            public String getValueFieldName() {
                return this.valueFieldName;
            }

            public void setValueFieldName(String valueFieldName) {
                this.valueFieldName = valueFieldName;
            }

            public Class getItemClass() {
                return this.itemClass;
            }

            public void setItemClass(Class itemClass) {
                this.itemClass = itemClass;
            }

            public int getFrom() {
                return this.from;
            }

            public void setFrom(int from) {
                this.from = from;
            }

            public int getTo() {
                return this.to;
            }

            public void setTo(int to) {
                this.to = to;
            }
        }

        private class FieldReader {
            protected String chineseName;
            protected Field field;
            protected int index = 0;

            private FieldReader() {
            }

            public Object read(Cell cell, RowReader<T> rowReader) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, InstantiationException {
                Object value;
                block7: {
                    String content = cell.getContents().trim();
                    Object instance = rowReader.getInstance();
                    value = null;
                    if (content.length() > 0) {
                        Method method = Parser.this.clazz.getMethod(Parser.this.generateSetMethod(this.field.getName()), this.field.getType());
                        if (!String.class.getName().equals(this.field.getType().getName())) {
                            try {
                                if (Date.class.getName().equals(this.field.getType().getName())) {
                                    DateCell dc = (DateCell)cell;
                                    value = dc.getDate();
                                    method.invoke(instance, value);
                                    break block7;
                                }
                                value = AdvancedParseExcelComponent.this.myConversionService.convert((Object)content, this.field.getType());
                                method.invoke(instance, value);
                            }
                            catch (Exception e) {
                                Parser.this.warnMessages.add("\u7b2c" + (rowReader.getRowNumber() + 1) + "\u884c\u4e2d," + this.chineseName + "\u683c\u5f0f\u4e0d\u6b63\u786e");
                                Parser.this.errorMessages.add((ObjectError)new FieldError(Parser.this.clazz.getName(), this.field.getName(), "\u7b2c" + rowReader.getRowNumber() + "\u884c\u4e2d," + this.chineseName + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
                            }
                        } else {
                            value = content;
                            method.invoke(instance, value);
                        }
                    } else {
                        rowReader.incNullCount();
                    }
                }
                return value;
            }

            public String getChineseName() {
                return this.chineseName;
            }

            public void setChineseName(String chineseName) {
                this.chineseName = chineseName;
            }

            public Field getField() {
                return this.field;
            }

            public void setField(Field field) {
                this.field = field;
            }

            public int getIndex() {
                return this.index;
            }

            public void setIndex(int index) {
                this.index = index;
            }
        }
    }
}

