/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLUtil {
    public static final Logger log = LoggerFactory.getLogger(XMLUtil.class);

    public static String parseString(String express, String xml) throws XPathExpressionException {
        if (StringUtils.isNotBlank((String)xml)) {
            XPath xPath = XMLUtil.getXPath();
            return (String)xPath.evaluate(express, new InputSource(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8))), XPathConstants.STRING);
        }
        return null;
    }

    public static NodeList parseNodeList(String express, String xml) throws XPathExpressionException {
        if (StringUtils.isNotBlank((String)xml)) {
            XPath xPath = XMLUtil.getXPath();
            return (NodeList)xPath.evaluate(express, new InputSource(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8))), XPathConstants.NODESET);
        }
        return null;
    }

    public static XPath getXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static <T> List<T> getObjecList(String filePath, Class<T> clazz, String childNote) throws Exception {
        Document doc = null;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            SAXReader reader = new SAXReader();
            doc = reader.read(new File(filePath));
            Element rootElt = doc.getRootElement();
            log.info("root node:{}", (Object)rootElt.getName());
            Iterator it = rootElt.elementIterator(childNote);
            while (it.hasNext()) {
                Element elementGroupService = (Element)it.next();
                Object baseBean = XMLUtil.fromXmlToBean(elementGroupService, clazz);
                list.add(baseBean);
            }
        }
        catch (DocumentException e) {
            log.error("read document exception! {}", (Throwable)e);
        }
        return list;
    }

    public static Object fromXmlToBean(Element rootElt, Class clazz) throws Exception {
        Field[] fields = clazz.getDeclaredFields();
        Object obj = clazz.newInstance();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                String name = field.getName();
                rootElt.elementTextTrim(name);
                if (rootElt.elementTextTrim(name) == null || "".equals(rootElt.elementTextTrim(name))) continue;
                if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
                    field.set(obj, Long.parseLong(rootElt.elementTextTrim(name)));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(obj, rootElt.elementTextTrim(name));
                    continue;
                }
                if (field.getType().equals(Double.class) || field.getType().equals(Double.TYPE)) {
                    field.set(obj, Double.parseDouble(rootElt.elementTextTrim(name)));
                    continue;
                }
                if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
                    field.set(obj, Integer.parseInt(rootElt.elementTextTrim(name)));
                    continue;
                }
                if (!field.getType().equals(Date.class)) continue;
                field.set(obj, Date.parse(rootElt.elementTextTrim(name)));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return obj;
    }
}

