/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;

public class FileUtil {
    private static final String[] IMAGE_NAMES = new String[]{"bmp", "dib", "gif", "jfif", "jpe", "jpeg", "jpg", "png", "tif", "tiff", "ico"};

    public static Boolean exists(String filePath) {
        File file;
        Boolean result = false;
        if (EmptyUtil.isNotEmpty(filePath) && (file = new File(filePath)).exists() && file.canRead()) {
            result = true;
        }
        return result;
    }

    public static byte[] getByteFileData(String filePath) throws IOException {
        if (FileUtil.exists(filePath).booleanValue()) {
            File file = new File(filePath);
            return FileUtils.readFileToByteArray((File)file);
        }
        throw new IOException("file is not exist");
    }

    public static Boolean InputStreamTOFile(InputStream in, String filePath) throws IOException {
        if (EmptyUtil.isNotEmpty(in) && EmptyUtil.isNotEmpty(filePath)) {
            File file = new File(filePath);
            byte[] b = IOUtils.toByteArray((InputStream)in);
            FileUtils.writeByteArrayToFile((File)file, (byte[])b);
            IOUtils.closeQuietly((InputStream)in);
            return true;
        }
        return false;
    }

    public static String getExtName(String fileName) {
        if (EmptyUtil.isEmpty(fileName)) {
            return "";
        }
        if (!fileName.contains(".")) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static boolean isImage(String extName) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(extName) && ArrayUtils.contains((Object[])IMAGE_NAMES, (Object)extName.toLowerCase())) {
            result = true;
        }
        return result;
    }

    public static boolean isPdf(String extName) {
        boolean result = false;
        if (EmptyUtil.isNotEmpty(extName) && extName.toLowerCase().equals(FILES.PDF.value)) {
            result = true;
        }
        return result;
    }

    public static Boolean resize(int width, int height, String filePath) throws IOException {
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        BufferedImage targetImage = ImageIO.read(new File(filePath));
        BufferedImage image = new BufferedImage(width, height, 1);
        image.getGraphics().drawImage(targetImage, 0, 0, width, height, Color.WHITE, null);
        String formatName = filePath.substring(filePath.lastIndexOf(".") + 1);
        return ImageIO.write((RenderedImage)image, formatName, new File(filePath));
    }

    public static void resize(int width, int height, String filePath, boolean fillWhite) {
        try {
            double ratio = 0.0;
            File file = new File(filePath);
            BufferedImage tempBufferedImage = ImageIO.read(file);
            Image targetImage = tempBufferedImage.getScaledInstance(width, height, 4);
            if (tempBufferedImage.getHeight() > height || tempBufferedImage.getWidth() > width) {
                ratio = tempBufferedImage.getHeight() > tempBufferedImage.getWidth() ? new Integer(height).doubleValue() / (double)tempBufferedImage.getHeight() : new Integer(width).doubleValue() / (double)tempBufferedImage.getWidth();
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
                targetImage = op.filter(tempBufferedImage, null);
            }
            if (fillWhite) {
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D graphics2D = image.createGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, width, height);
                if (width == targetImage.getWidth(null)) {
                    graphics2D.drawImage(targetImage, 0, (height - targetImage.getHeight(null)) / 2, targetImage.getWidth(null), targetImage.getHeight(null), Color.white, null);
                } else {
                    graphics2D.drawImage(targetImage, (width - targetImage.getWidth(null)) / 2, 0, targetImage.getWidth(null), targetImage.getHeight(null), Color.white, null);
                }
                graphics2D.dispose();
                targetImage = image;
            }
            ImageIO.write((RenderedImage)((BufferedImage)targetImage), "jpg", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static enum FILES {
        PDF("pdf"),
        HTML("html"),
        EXCEL("excel"),
        DOC("doc");

        private String value;

        private FILES(String value) {
            this.value = value;
        }
    }
}

