/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class FileDownLoadBuilder {
    private static final Logger log = LoggerFactory.getLogger(FileDownLoadBuilder.class);
    private String name = null;
    private byte[] bytes = null;
    private MediaType mediaType = MediaType.APPLICATION_OCTET_STREAM;

    public FileDownLoadBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FileDownLoadBuilder type(MediaType mediaType) {
        try {
            this.mediaType = mediaType;
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        return this;
    }

    public FileDownLoadBuilder file(byte[] bytes) {
        this.bytes = bytes;
        return this;
    }

    public FileDownLoadBuilder file(InputStream inputStream) {
        try {
            this.bytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        return this;
    }

    public FileDownLoadBuilder file(File file) {
        this.name = (String)StringUtils.defaultIfBlank((CharSequence)this.name, (CharSequence)file.getName());
        try {
            this.bytes = FileUtils.readFileToByteArray((File)file);
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        return this;
    }

    public FileDownLoadBuilder file(String path) {
        ClassPathResource classPathResource = new ClassPathResource(path);
        this.name = (String)StringUtils.defaultIfBlank((CharSequence)this.name, (CharSequence)classPathResource.getFilename());
        InputStream is = null;
        try {
            is = classPathResource.getInputStream();
        }
        catch (IOException e) {
            log.error(null, (Throwable)e);
        }
        return this.file(is);
    }

    public ResponseEntity<byte[]> builder() {
        try {
            this.name = new String(this.name.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(this.mediaType);
        headers.setContentDispositionFormData("attachment", this.name);
        return new ResponseEntity((Object)this.bytes, (MultiValueMap)headers, HttpStatus.OK);
    }
}

