/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static byte[] write(String sheetName, List<List<String>> allLines, boolean oldVersion) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HSSFWorkbook wb = oldVersion ? new HSSFWorkbook() : new XSSFWorkbook();
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        CellStyle style = wb.createCellStyle();
        style.setAlignment((short)3);
        style.setWrapText(true);
        for (int i = 0; i < allLines.size(); ++i) {
            row = sheet.createRow(i);
            List<String> line = allLines.get(i);
            for (int j = 0; j < line.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellType(1);
                cell.setCellValue(line.get(j));
            }
        }
        try {
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os.toByteArray();
    }

    public static byte[] write(Map<String, List<List<String>>> sheets, boolean oldVersion) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HSSFWorkbook wb = oldVersion ? new HSSFWorkbook() : new XSSFWorkbook();
        Set<String> sheetNames = sheets.keySet();
        for (String sheetName : sheetNames) {
            List<List<String>> allLines = sheets.get(sheetName);
            Sheet sheet = wb.createSheet(sheetName);
            Row row = sheet.createRow(0);
            CellStyle style = wb.createCellStyle();
            style.setAlignment((short)3);
            style.setWrapText(true);
            for (int i = 0; i < allLines.size(); ++i) {
                row = sheet.createRow(i);
                List<String> line = allLines.get(i);
                for (int j = 0; j < line.size(); ++j) {
                    Cell cell = row.createCell(j);
                    cell.setCellType(1);
                    cell.setCellValue(line.get(j));
                }
            }
        }
        try {
            wb.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            throw new RuntimeException("Write Excel File Error");
        }
        return os.toByteArray();
    }

    public static List<List<String>> read(InputStream is, boolean oldVersion) {
        return ExcelUtil.read(is, 0, oldVersion);
    }

    public static List<List<String>> read(InputStream is, int page, boolean oldVersion) {
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        HSSFWorkbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            sheet = workbook.getSheetAt(page);
            int headLength = 0;
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                ArrayList<String> line = new ArrayList<String>();
                if (row.getPhysicalNumberOfCells() > headLength) {
                    headLength = row.getPhysicalNumberOfCells();
                }
                for (int j = 0; j < headLength; ++j) {
                    cell = row.getCell(j);
                    if (cell != null && 0 == cell.getCellType() && HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        line.add(DateUtil.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()), "yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    String cellValue = cell != null ? (1 == cell.getCellType() ? cell.getStringCellValue() : (3 == cell.getCellType() ? "" : new Double(cell.getNumericCellValue()).intValue() + "")) : "";
                    line.add(EmptyUtil.isNotEmpty(cellValue) ? cellValue.trim() : "");
                }
                allLines.add(line);
            }
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            return null;
        }
        return allLines;
    }

    public static List<List<String>> readProdSku(InputStream is, int page, boolean oldVersion) {
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        HSSFWorkbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            sheet = workbook.getSheetAt(page);
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                ArrayList<String> line = new ArrayList<String>();
                for (int j = 0; j < 2; ++j) {
                    cell = row.getCell(j);
                    if (cell != null && 0 == cell.getCellType() && HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        line.add(DateUtil.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()), "yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    String cellValue = cell != null ? (1 == cell.getCellType() ? cell.getStringCellValue() : new Double(cell.getNumericCellValue()).intValue() + "") : "";
                    line.add(EmptyUtil.isNotEmpty(cellValue) ? cellValue.trim() : "");
                }
                allLines.add(line);
            }
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            return null;
        }
        return allLines;
    }

    public static List<List<String>> readNormal(InputStream is, int page, boolean oldVersion) {
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        HSSFWorkbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        try {
            workbook = oldVersion ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            sheet = workbook.getSheetAt(page);
            for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                ArrayList<String> line = new ArrayList<String>();
                for (int j = 0; j < row.getPhysicalNumberOfCells(); ++j) {
                    cell = row.getCell(j);
                    if (cell != null && 0 == cell.getCellType() && HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        line.add(DateUtil.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()), "yyyy-MM-dd HH:mm:ss"));
                        continue;
                    }
                    String cellValue = cell != null ? (1 == cell.getCellType() ? cell.getStringCellValue() : new Double(cell.getNumericCellValue()) + "") : "";
                    line.add(EmptyUtil.isNotEmpty(cellValue) ? cellValue.trim() : "");
                }
                allLines.add(line);
            }
        }
        catch (IOException e) {
            log.warn("", (Throwable)e);
            return null;
        }
        return allLines;
    }
}

