/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelImportBuilder {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportBuilder.class);
    private MultipartFile multipartFile = null;
    private int columnNum = 0;

    public ExcelImportBuilder fileName(MultipartFile multipartFile) {
        this.multipartFile = multipartFile;
        return this;
    }

    public ExcelImportBuilder col(int columnNum) {
        this.columnNum = columnNum;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> builder() {
        Workbook wb = null;
        ArrayList<String[]> result = new ArrayList<String[]>();
        try {
            InputStream inputStream = this.multipartFile.getInputStream();
            wb = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet1 = wb.getSheetAt(0);
            int i = 0;
            for (Row row : sheet1) {
                if (++i == 1) continue;
                if (StringUtils.isBlank((String)this.getCellValue(row.getCell(0)))) break;
                String[] array = new String[this.columnNum];
                for (int j = 0; j < this.columnNum; ++j) {
                    String value;
                    array[j] = value = this.getCellValue(row.getCell(j));
                }
                result.add(array);
            }
        }
        catch (Exception e) {
            try {
                log.error(null, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(wb);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)wb);
        }
        IOUtils.closeQuietly((Closeable)wb);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> builderNotColumnNum() {
        Workbook wb = null;
        ArrayList<String[]> result = new ArrayList<String[]>();
        try {
            InputStream inputStream = this.multipartFile.getInputStream();
            wb = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet1 = wb.getSheetAt(0);
            int i = 0;
            for (Row row : sheet1) {
                if (++i == 1) continue;
                int count = row.getLastCellNum();
                String[] array = new String[count];
                for (int j = 0; j < count; ++j) {
                    String value;
                    array[j] = value = this.getCellValue(row.getCell(j));
                }
                result.add(array);
            }
        }
        catch (Exception e) {
            try {
                log.error(null, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(wb);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)wb);
        }
        IOUtils.closeQuietly((Closeable)wb);
        return result;
    }

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        int type = cell.getCellType();
        String result = "";
        if (type == 0) {
            Double d = cell.getNumericCellValue();
            result = d.intValue() + "";
        } else if (type == 1) {
            result = cell.getStringCellValue();
        }
        return result;
    }
}

