/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumUtil {
    public static <T extends Enum> List<T> toList(Class<T> clazz) {
        return Arrays.asList(clazz.getEnumConstants());
    }

    public static <T extends Enum> Map<Object, T> toMap(Class<T> clazz, String methodName) {
        return EnumUtil.enumConstantDirectory(clazz, methodName);
    }

    private static <T extends Enum> Map<Object, T> enumConstantDirectory(Class<T> clazz, String methodName) {
        HashMap<String, Enum> directory = null;
        if (directory == null) {
            Enum[] universe = EnumUtil.getEnumConstantsShared(clazz);
            if (universe == null) {
                throw new IllegalArgumentException(clazz.getName() + " is not an enum type");
            }
            HashMap<String, Enum> m = new HashMap<String, Enum>(2 * universe.length);
            for (Enum constant : universe) {
                try {
                    Object key = null;
                    if (methodName != null && methodName.trim().length() > 0) {
                        Method method = constant.getClass().getMethod(methodName, new Class[0]);
                        key = method.invoke((Object)constant, new Object[0]);
                    } else {
                        key = constant.name();
                    }
                    m.put((String)key, constant);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            directory = m;
        }
        return directory;
    }

    private static <T extends Enum> T[] getEnumConstantsShared(Class<T> clazz) {
        Enum[] enumConstants = null;
        if (enumConstants == null) {
            if (!clazz.isEnum()) {
                return null;
            }
            try {
                Enum[] temporaryConstants;
                final Method values = clazz.getMethod("values", new Class[0]);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        values.setAccessible(true);
                        return null;
                    }
                });
                enumConstants = temporaryConstants = (Enum[])values.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                return null;
            }
        }
        return enumConstants;
    }
}

