/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_STR_FORMAT = "yyyyMMddHHmmss";
    public static final String DATE_STR_FORMAT = "yyyyMMddHHmmssSSS";
    public static final String DATE_FORMAT = "dd";
    public static final String MOUNTH_FORMAT = "MM";

    private static final SimpleDateFormat getFormat(String pattern, Locale locale) {
        return new SimpleDateFormat(pattern, locale);
    }

    public static String format(Date date, String pattern) {
        return DateUtil.format(date, pattern, Locale.getDefault());
    }

    public static String format(Date date, String pattern, Locale locale) {
        if (date == null) {
            return "";
        }
        if (StringUtils.isNotBlank((String)pattern)) {
            String format = DateUtil.getFormat(pattern, locale).format(date);
            return format;
        }
        throw new IllegalArgumentException("param pattern can not be null");
    }

    public static Date parse(String dateString, String pattern) {
        return DateUtil.parse(dateString, pattern, Locale.getDefault());
    }

    public static Date parse(String dateString, String pattern, Locale locale) {
        if (StringUtils.isNotBlank((String)dateString)) {
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = DateUtil.getFormat(pattern, locale).parse(dateString, parsePosition);
            Object[] objects = new Object[]{dateString, pattern};
            log.debug("dateString:[{}], pattern:[{}], parsePosition:[{}]", objects);
            return date;
        }
        throw new IllegalArgumentException("param dateString can not be null");
    }

    public static Date add(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int amount) {
        return DateUtil.add(date, 6, amount);
    }

    public static Date addYears(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, num);
        return cal.getTime();
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtil.add(date, 12, amount);
    }

    public static Date dayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date dayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date dayEndSecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String weekDayInChinese() {
        return DateUtil.weekDayInChinese(new Date());
    }

    public static String weekDayInChinese(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int week = calendar.get(7);
        switch (week) {
            case 1: {
                return "\u65e5";
            }
            case 2: {
                return "\u4e00";
            }
            case 3: {
                return "\u4e8c";
            }
            case 4: {
                return "\u4e09";
            }
            case 5: {
                return "\u56db";
            }
            case 6: {
                return "\u4e94";
            }
            case 7: {
                return "\u516d";
            }
        }
        return "";
    }

    public static Date getNow() {
        return new Date();
    }

    public static int getCurrYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getCurrMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    private static Date getLastOrNextWeek(int week, int weekNum) {
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setFirstDayOfWeek(2);
        currentDate.set(7, week);
        currentDate.add(3, weekNum);
        Date nextWeek = currentDate.getTime();
        return nextWeek;
    }

    public static Date getLastWeek(int weekNum, int nextNum) {
        return DateUtil.getLastOrNextWeek(weekNum, -nextNum);
    }

    public static Date getCurrWeek(int weekNum) {
        return DateUtil.getLastOrNextWeek(weekNum, 0);
    }

    public static Date getNextWeek(int weekNum, int nextNum) {
        return DateUtil.getLastOrNextWeek(weekNum, nextNum);
    }

    private static Date getLastFriday() {
        return DateUtil.getLastWeek(6, 1);
    }

    public static Date getLastFridayStart() {
        Date fridayStart = DateUtil.getLastFriday();
        return DateUtil.dayStart(fridayStart);
    }

    public static Date getLastFridayEnd() {
        Date fridayEnd = DateUtil.getLastFriday();
        return DateUtil.dayEnd(fridayEnd);
    }

    private static Date getNextFriday() {
        return DateUtil.getNextWeek(6, 1);
    }

    public static Date getNextFridayStart() {
        Date fridayStart = DateUtil.getNextFriday();
        return DateUtil.dayStart(fridayStart);
    }

    public static Date getNextFridayEnd() {
        Date nextFridayEnd = DateUtil.getNextFriday();
        return DateUtil.dayEnd(nextFridayEnd);
    }

    public static Date getCurrFriday() {
        return DateUtil.getCurrWeek(6);
    }

    public static Date getCurrFridayStart() {
        Date date = DateUtil.getCurrFriday();
        return DateUtil.dayStart(date);
    }

    public static Date getCurrFridayEnd() {
        Date date = DateUtil.getCurrFriday();
        return DateUtil.dayEnd(date);
    }

    public static int daysBetween(Date smdate, Date bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static boolean isInTime(String strDateBegin, String strDateEnd) {
        int strDateBeginH = Integer.parseInt(strDateBegin.substring(0, 2));
        int strDateBeginM = Integer.parseInt(strDateBegin.substring(3, 5));
        int strDateBeginS = Integer.parseInt(strDateBegin.substring(6, 8));
        int strDateEndH = Integer.parseInt(strDateEnd.substring(0, 2));
        int strDateEndM = Integer.parseInt(strDateEnd.substring(3, 5));
        int strDateEndS = Integer.parseInt(strDateEnd.substring(6, 8));
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTime(Calendar.getInstance().getTime());
        calendarStart.set(11, strDateBeginH);
        calendarStart.set(12, strDateBeginM);
        calendarStart.set(13, strDateBeginS);
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(Calendar.getInstance().getTime());
        calendarEnd.set(11, strDateEndH);
        calendarEnd.set(12, strDateEndM);
        calendarEnd.set(13, strDateEndS);
        return Calendar.getInstance().getTimeInMillis() >= calendarStart.getTimeInMillis() && Calendar.getInstance().getTimeInMillis() < calendarEnd.getTimeInMillis();
    }

    public static boolean termOfValidity(Date startDate, Date endDate) {
        if (null == startDate || null == endDate) {
            return false;
        }
        Calendar instance = Calendar.getInstance();
        Long nowTime = instance.getTime().getTime();
        return nowTime > startDate.getTime() && nowTime < endDate.getTime();
    }

    public static Boolean isInTime(Date startDate, Date endDate, Date date) {
        long startTimes = 0L;
        long endTime = 0L;
        long sourceTime = new Date().getTime();
        if (null != startDate) {
            startTimes = startDate.getTime();
        }
        if (null != endDate) {
            endTime = endDate.getTime();
        }
        if (null != date) {
            sourceTime = date.getTime();
        }
        if (startTimes <= sourceTime && endTime >= sourceTime) {
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            Calendar instance = Calendar.getInstance();
            instance.add(5, -5);
            Date bdate = instance.getTime();
            instance.add(5, 15);
            Date smdate = instance.getTime();
            System.out.println(DateUtil.termOfValidity(bdate, smdate));
            System.out.println(DateUtil.getCurrYear());
            System.out.println(DateUtil.getCurrMonth());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

