/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class DateTool {
    public static final String FORMAT_DATE_YEAR = "yyyy";
    public static final String FORMAT_DATE_YEAR_MONTH = "yyyy-MM";
    public static final String FORMAT_DATE = "yyyy-MM-dd";
    public static final String FORMAT_TIME = "HH:mm:ss";
    public static final String FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATETIME2 = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_MICROSECOND = "yyyyMMddHHmmssmmm";
    public static final String FORMAT_DATE_2 = "yyyyMMdd";
    public static final String FORMAT_DATE_3 = "MM/dd/yyyy";
    public static final String FORMAT_DATE_4 = "MM/dd/yyyy HH:mm";
    public static final String FORMAT_DATE_5 = "MM-dd";
    public static final String FORMAT_DATE_6 = "M\u6708d\u65e5";
    public static final String MONGOSTRINGTODATE = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static Logger logger = Logger.getLogger(DateTool.class);

    public static String date2String(Date date, String format) {
        String result = null;
        if (date == null) {
            return result;
        }
        if (StringUtils.isEmpty((String)format)) {
            format = FORMAT_DATE;
        }
        try {
            result = DateFormatUtils.format((Date)date, (String)format);
        }
        catch (Exception ex) {
            logger.warn((Object)("\u65e5\u671f\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u9519\u8bef\uff0c\u65e5\u671f\uff1a" + date.toString() + "\uff0c \u683c\u5f0f\uff1a" + format));
        }
        return result;
    }

    public static Date string2Date(String str, String format) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        Date result = null;
        String[] formats = null;
        formats = StringUtils.isEmpty((String)format) ? new String[]{FORMAT_DATETIME, FORMAT_DATE, FORMAT_TIME} : new String[]{format, FORMAT_DATETIME, FORMAT_DATE, FORMAT_TIME};
        try {
            result = DateUtils.parseDate((String)str, (String[])formats);
        }
        catch (Exception ex) {
            logger.warn((Object)("\u65e5\u671f\u6216\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32\uff1a" + str + "\uff0c \u683c\u5f0f\uff1a" + format));
        }
        return result;
    }

    public static java.sql.Date string2SqlDate(String str, String format) {
        return new java.sql.Date(DateTool.string2Date(str, format).getTime());
    }

    public static String timestamp2String(Timestamp ts, String format) {
        return ts == null ? null : DateTool.date2String(new Date(ts.getTime()), format);
    }

    public static Timestamp string2Timestamp(String str, String format) {
        return DateTool.string2Date(str, format) == null ? null : new Timestamp(DateTool.string2Date(str, format).getTime());
    }

    public static Date addYears(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, num);
        return cal.getTime();
    }

    public static Date addMonths(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, num);
        return cal.getTime();
    }

    public static Date addDays(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, num);
        return cal.getTime();
    }

    public static Date addHours(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, num);
        return cal.getTime();
    }

    public static Date addTime(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, num);
        return cal.getTime();
    }

    public static Date getFirstDateOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(6, cal.getActualMinimum(6));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static String getFirstDateOfMonth(Date date, String format) {
        Date firstDay = DateTool.getFirstDateOfMonth(date);
        return DateTool.date2String(firstDay, format);
    }

    public static Date getLastDateOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(6, cal.getActualMaximum(6));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String getLastDateOfMonth(Date date, String format) {
        Date lastDay = DateTool.getLastDateOfMonth(date);
        return DateTool.date2String(lastDay, format);
    }

    public static String getStringDayOfWeek(Date date) {
        String result = "";
        if (null != date) {
            SimpleDateFormat formatter4 = new SimpleDateFormat("E");
            result = formatter4.format(date);
        }
        return result;
    }

    public static Map<String, String> getyyyyMMddDateMap(String date) {
        if (date.length() == 8) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("year", date.substring(0, 4));
            map.put("month", date.substring(4, 6));
            map.put("day", date.substring(6, 8));
            return map;
        }
        return null;
    }

    public static String getCurrentHMSSSS() {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmssSSS");
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static String getCurrentDateYYMMDD() {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_DATE_2);
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static String getCurrentDateYY_MM_DD() {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_DATE);
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static int compareDate(String DATE1, String DATE2) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_DATE);
        try {
            Date dt1 = df.parse(DATE1);
            Date dt2 = df.parse(DATE2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static Date mongoStringTodate(String date) {
        Date stringToDate = null;
        SimpleDateFormat df = new SimpleDateFormat(MONGOSTRINGTODATE, Locale.ENGLISH);
        try {
            stringToDate = df.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return stringToDate;
    }
}

