/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.util.comm;

public final class ByteUtil {
    private static final char[] digit2char = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String bytesToHexStringLowerCase(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(ByteUtil.byteToHexStringLowerCase(b[i]));
        }
        return resultSb.toString();
    }

    public static String byteToHexStringLowerCase(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        int d1 = i / 16;
        int d2 = i % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static String bytesToHexStringUpperCase(byte[] bytes) {
        if (null == bytes) {
            throw new IllegalArgumentException("bytes\u4e0d\u80fd\u4e3a\u7a7a");
        }
        char[] tmpData = new char[bytes.length << 1];
        for (int i = 0; i < bytes.length; ++i) {
            int left = (bytes[i] & 0xF0) >> 4;
            tmpData[i << 1] = digit2char[left];
            int right = bytes[i] & 0xF;
            tmpData[(i << 1) + 1] = digit2char[right];
        }
        return new String(tmpData);
    }

    public static byte uniteBytes(byte byte1, byte byte2) {
        byte _b0 = Byte.decode("0x" + new String(new byte[]{byte1}));
        _b0 = (byte)(_b0 << 4);
        byte _b1 = Byte.decode("0x" + new String(new byte[]{byte2}));
        byte ret = (byte)(_b0 ^ _b1);
        return ret;
    }

    public static byte[] hexBytesToBytes(byte[] bytes) {
        if (null != bytes) {
            int length = bytes.length;
            if (length % 2 != 0) {
                throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u662f\u5076\u6570");
            }
            byte[] bytes2 = new byte[length / 2];
            String item = "";
            for (int n = 0; n < length; n += 2) {
                item = new String(bytes, n, 2);
                bytes2[n / 2] = (byte)Integer.parseInt(item, 16);
            }
            return bytes2;
        }
        return null;
    }
}

