package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.support.vo.price.PriceInfoVO;
import com.thebeastshop.support.vo.product.SimpleProductVO.DiscVO;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * @author Paul-xiong
 */
public class SpvVO implements Serializable {

    private static final long serialVersionUID = 3525809972231619743L;

    /********** 基本信息 **********/
    private Long id;                        //spvId
    private String name;                    //spv名称
    private String productCode;             //商品 code（XXX:临时需要,以后可能会移除）
    private String spvDesc;                 //描述
    private Integer left;                   //剩余库存量
    private String image;                   //默认图片
    private BigDecimal rawPrice;            //原价
    private BigDecimal price;               //折扣价
    private BigDecimal pointPrice;          //积分价
    private Integer point;                  //兑换积分
    private String summary;                 //一句话推荐
    private int minAmount = 1;              //最小购买数量，默认为 1
    private String installDesc;             //安装描述
    private String stockWarn;               //库存预警文案
    private BigDecimal refunds;             //返还基金
    private String refundsName;             //返还基金活动名

    private BrandVO brand = new BrandVO();  //品牌对象
    private Quota quota;                    //可购买限额对象
    private PreSellVO presell;              //预售商品对象，若不是预售，则为 null
    private PreDeliverVO preDeliver;        //预计发货对象
    private PriceInfoVO priceInfo;          //价格明细对象
    private DiscVO discount;                //APP专享价对象

    private List<Integer> levelIds;         //兑换会员等级列表
    private List<String> skuCodes;          //skuCode列表（XXX:临时需要,以后可能会移除）
    private List<String> deliveryDates;     //配送日期列表
    private List<SpvVO> combinedSingleSpvs; //组合商品列表
    private List<PriceTagVO> priceTags;     //价格标签列表
    private Collection<Integer> group;      //规格维度的选项组合

    /********** 各种标记 **********/
    private boolean cheap = false;          //是否低价销售
    private boolean combined = false;       //是否组合商品
    private boolean combination = false;    //是否组合搭配商品
    private Boolean isOversea = false;      //是否海淘
    private Boolean rush = false;           //是否抢购
    private Boolean newcomerTag = false;    //是否新人价
    private Boolean onLineOnly = false;     //是否官网专享
    private Boolean allowCampaign = true;   //是否参与活动优惠券
    private Boolean allowCoupon = true;     //是否参与活动优惠券

    /********** 过时字段 **********/
    private String firstDeliveryDate;       //第一次配送日期
    private FlashSaleVO flashSale;          //闪购


    public static long getSerialversionuid() {
        return serialVersionUID;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getLeft() {
        return left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getSpvDesc() {
        return spvDesc;
    }

    public void setSpvDesc(String spvDesc) {
        this.spvDesc = spvDesc;
    }

    public BrandVO getBrand() {
        return brand;
    }

    public void setBrand(BrandVO brand) {
        this.brand = brand;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getRawPrice() {
        return rawPrice;
    }

    public void setRawPrice(BigDecimal rawPrice) {
        this.rawPrice = rawPrice;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public PriceInfoVO getPriceInfo() {
        return priceInfo;
    }

    public void setPriceInfo(PriceInfoVO priceInfo) {
        this.priceInfo = priceInfo;
    }

    public BigDecimal getPointPrice() {
        return pointPrice;
    }

    public void setPointPrice(BigDecimal pointPrice) {
        this.pointPrice = pointPrice;
    }

    public Integer getPoint() {
        return point;
    }

    public void setPoint(Integer point) {
        this.point = point;
    }

    public List<Integer> getLevelIds() {
        return levelIds;
    }

    public void setLevelIds(List<Integer> levelIds) {
        this.levelIds = levelIds;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public int getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(int minAmount) {
        this.minAmount = minAmount;
    }

    public Collection<Integer> getGroup() {
        return group;
    }

    public void setGroup(Collection<Integer> group) {
        this.group = group;
    }

    public List<String> getDeliveryDates() {
        return deliveryDates;
    }

    public void setDeliveryDates(List<String> deliveryDates) {
        this.deliveryDates = deliveryDates;
    }

    public String getFirstDeliveryDate() {
        return firstDeliveryDate;
    }

    public void setFirstDeliveryDate(String firstDeliveryDate) {
        this.firstDeliveryDate = firstDeliveryDate;
    }

    public boolean isCheap() {
        return cheap;
    }

    public void setCheap(boolean cheap) {
        this.cheap = cheap;
    }

    public boolean isCombined() {
        return combined;
    }

    public void setCombined(boolean combined) {
        this.combined = combined;
    }

    public boolean isCombination() {
        return combination;
    }

    public void setCombination(boolean combination) {
        this.combination = combination;
    }

    public List<SpvVO> getCombinedSingleSpvs() {
        return combinedSingleSpvs;
    }

    public void setCombinedSingleSpvs(List<SpvVO> combinedSingleSpvs) {
        this.combinedSingleSpvs = combinedSingleSpvs;
    }

    public Quota getQuota() {
        return quota;
    }

    public void setQuota(Quota quota) {
        this.quota = quota;
    }

    public PreSellVO getPresell() {
        return presell;
    }

    public void setPresell(PreSellVO presell) {
        this.presell = presell;
    }

    public PreDeliverVO getPreDeliver() {
		return preDeliver;
	}

	public void setPreDeliver(PreDeliverVO preDeliver) {
		this.preDeliver = preDeliver;
	}

	public FlashSaleVO getFlashSale() {
        return flashSale;
    }

    public void setFlashSale(FlashSaleVO flashSale) {
        this.flashSale = flashSale;
    }

    public DiscVO getDiscount() {
        return discount;
    }

    public void setDiscount(DiscVO discount) {
        this.discount = discount;
    }
    
    public String getInstallDesc() {
		return installDesc;
	}

	public void setInstallDesc(String installDesc) {
		this.installDesc = installDesc;
	}
	
	public Boolean getIsOversea() {
		return isOversea;
	}

	public void setIsOversea(Boolean isOversea) {
		this.isOversea = isOversea;
	}

	public Boolean getRush() {
		return rush;
	}

	public void setRush(Boolean rush) {
		this.rush = rush;
	}
	
	public Boolean getNewcomerTag() {
		return newcomerTag;
	}

	public void setNewcomerTag(Boolean newcomerTag) {
		this.newcomerTag = newcomerTag;
	}

    public Boolean getOnLineOnly() {
        return onLineOnly;
    }

    public void setOnLineOnly(Boolean onLineOnly) {
        this.onLineOnly = onLineOnly;
    }

    public Boolean getAllowCampaign() {
        return allowCampaign;
    }

    public void setAllowCampaign(Boolean allowCampaign) {
        this.allowCampaign = allowCampaign;
    }

    public Boolean getAllowCoupon() {
        return allowCoupon;
    }

    public void setAllowCoupon(Boolean allowCoupon) {
        this.allowCoupon = allowCoupon;
    }

    public List<PriceTagVO> getPriceTags() {
        return priceTags;
    }

    public void setPriceTags(List<PriceTagVO> priceTags) {
        this.priceTags = priceTags;
    }

    public String getStockWarn() {
        return stockWarn;
    }

    public void setStockWarn(String stockWarn) {
        this.stockWarn = stockWarn;
    }

    public BigDecimal getRefunds() {
        return refunds;
    }

    public void setRefunds(BigDecimal refunds) {
        this.refunds = refunds;
    }

    public String getRefundsName() {
        return refundsName;
    }

    public void setRefundsName(String refundsName) {
        this.refundsName = refundsName;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }

    /**
     * 品牌
     *
     * @author Paul-xiong
     */
    public static class BrandVO implements Serializable {
        /**
         *
         */
        private static final long serialVersionUID = 1L;
        private long id;
        private String name = "";
        private String brandCountryName="";

        public long getId() {
            return id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBrandCountryName() {
            return brandCountryName;
        }

        public void setBrandCountryName(String brandCountryName) {
            this.brandCountryName = brandCountryName;
        }

        public BrandVO() {
        	super();
        }
        
        public BrandVO(long id, String name) {
        	this.id = id;
        	this.name = name;
        }

        public BrandVO(long id, String name, String brandCountryName) {
            this.id = id;
            this.name = name;
            this.brandCountryName = brandCountryName;
        }

        @Override
        public String toString() {
            return new ToStringBuilder(this)
                    .append("id", id)
                    .append("name", name)
                    .append("brandCountryName", brandCountryName)
                    .toString();
        }

    }

    /**
     * 可购买限额
     *
     * @author ztq
     */
    public static class Quota implements Serializable {
        private static final long serialVersionUID = 1L;
        /**
         * 当前剩下的可购买额度
         */
        private int left = -1;
        /**
         * 总可购买额度
         */
        private int total = -1;

        public int getLeft() {
            return left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public int getTotal() {
            return total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

    }

    /**
     * 闪购
     *
     * @author Yawei-wang
     */
    public static class FlashSaleVO implements Serializable {

        /**
         * @Field long serialVersionUID
         */
        private static final long serialVersionUID = 1L;

        /**
         * 如果不是闪购，或者闪购有效期之外，则为 null
         */
        private Timestamp expiresAt;// 单位秒，距离闪购结束的时间

        private boolean soldOut;// 闪购限额已经售光。如果在闪购有效期内，且闪购限额已经售光，则商品不能购买，显示为
        // soldout。

        public boolean isSoldOut() {
            return soldOut;
        }

        public Timestamp getExpiresAt() {
            return expiresAt;
        }

        public void setExpiresAt(Timestamp expiresAt) {
            this.expiresAt = expiresAt;
        }

        public void setSoldOut(boolean soldOut) {
            this.soldOut = soldOut;
        }

        @Override
        public String toString() {
            return "FlashSaleVO [expiresAt =" + expiresAt + ", soldOut =" + soldOut + "]";
        }
    }
    
    /**
     * 预计发货
     * @author xiang.gao
     * @date 2019/02/14
     */
    public static class PreDeliverVO implements Serializable{
    	/**
		 *
		 */
		private static final long serialVersionUID = 1L;
		/**
    	 * 0:预售 1:来单
    	 */
    	private Integer type;
    	/**
    	 * 预计发货时间
    	 */
    	private Date deliverAt;
    	/**
    	 * 发货信息描述
    	 */
    	private String content;

    	public Integer getType() {
    		return type;
    	}

    	public void setType(Integer type) {
    		this.type = type;
    	}

    	public Date getDeliverAt() {
    		return deliverAt;
    	}

    	public void setDeliverAt(Date deliverAt) {
    		this.deliverAt = deliverAt;
    	}

    	public String getContent() {
    		return content;
    	}

    	public void setContent(String content) {
    		this.content = content;
    	}
    }

}
