package com.thebeastshop.support.vo.product;

import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.flowerMonth.FlowerMonthDistType;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 商品基础信息
 * 
 * @author Paul-xiong
 *
 */
public class SimpleProductVO {

	/********** 基本信息 **********/
	private String id;							//商品id
	private String featureImage = "";			//商品列表图
	private String specialImage = "";           //商品专项图片，用于特殊场景如：选礼商品图片 sinse 4.7.0
	private String specialDesc = "";            //商品专项描述，用于特殊场景如：选礼商品描述 sinse 4.7.0
	private List<String> images = new ArrayList<String>();	//图片列表
	private List<Label> labels = new ArrayList<Label>();	//标签列表
	private List<String> waterMarkImage;		//水印列表
	private BigPicVO bigPic; 					//大图对象
	private VideoVO video;						//视频对象
	private BrandVO brand;						//品牌对象
	private String name;						//商品名
	private String summary;						//商品描述
	private BigDecimal price;					//售价
	private BigDecimal rawPrice;				//原价
	private BigDecimal pointPrice;  			//积分抵扣后价格
	private Integer point; 						//兑换积分数
	private String activityDesc;				//活动描述
	private String unSaleDesc; 					//不可售描述
	private BigDecimal commissionRate; 			//佣金比列
	private BigDecimal commissionAmount; 		//佣金金额
	private BigDecimal refunds; 				//购物返基金数额
	private String refundsName; 				//购物返基金活动名
	private String markInfo;          			//商品标记信息
	private String stockWarn;					//库存预警文案
	private String deliveryTag="00";       		//配送标识:默认00 - 可配送 01-地址不可送 02-日期不可送 03-日期地址都不可送

	/********** 业务对象 **********/
	private DiscVO discount;					//折扣标签对象
	private PriceForecastVO priceForecast;		//价格预告对象
	private List<ProductCampaignVO> campaigns;	//商品参与的活动列表

	/********** 各种标记 **********/
	private Boolean soldOut;					//是否售罄
	private Boolean invisible;					//是否不可见
	private Boolean offShelf;					//是否上架
	private Boolean isOversea = false;			//是否海淘
	private Boolean rush;						//是否抢购
	private Boolean hasJit = false; 			//是否来单
	private Boolean vipOnly = false;			//是否VIP专享
	private Boolean foretell = false;			//是否预告
	private Boolean hasPresale = false; 		//是否预售
	private Boolean customizable = false; 		//是否可定制
	private Boolean combined = false; 			//是否组合商品
	private Boolean combination = false; 		//是否组合搭配
	private Boolean pointDeduction= false; 		//是否可积分抵扣
	private Boolean newcomerTag = false; 		//是否新人价标签
	private Boolean birthdayGift = false; 		//是否生日礼商品
	private Boolean onLineOnly = false; 		//是否线上专享
	private Boolean allowCampaign = true; 		//是否可参与活动
	private Boolean allowCoupon = true;	  		//是否可使用优惠券

	/********** 过时字段 **********/
	private Boolean monthSend = false;			//是否月送鲜花
	private FlowerMonthDistType monthSendDistType = FlowerMonthDistType.EXPRESS;	//月送配送类型


	public BigPicVO getBigPic() {
		return bigPic;
	}

	public void setBigPic(BigPicVO bigPic) {
		this.bigPic = bigPic;
	}

	public Boolean getForetell() {
		return foretell;
	}

	public void setForetell(Boolean foretell) {
		this.foretell = foretell;
	}

	public String getActivityDesc() {
		return activityDesc;
	}

	public void setActivityDesc(String activityDesc) {
		this.activityDesc = activityDesc;
	}

	public Boolean getIsOversea() {
		return isOversea;
	}

	public void setIsOversea(Boolean isOversea) {
		this.isOversea = isOversea;
	}

	public Boolean getCustomizable() {
		return customizable;
	}

	public void setCustomizable(Boolean customizable) {
		this.customizable = customizable;
	}

	public Boolean getRush() {
		return rush;
	}

	public void setRush(Boolean rush) {
		this.rush = rush;
	}

	public PriceForecastVO getPriceForecast() {
		return priceForecast;
	}

	public void setPriceForecast(PriceForecastVO priceForecast) {
		this.priceForecast = priceForecast;
	}

	public DiscVO getDiscount() {
		return discount;
	}

	public void setDiscount(DiscVO discount) {
		this.discount = discount;
	}

	public SimpleProductVO() {
		super();
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getFeatureImage() {
		return featureImage;
	}

	public void setFeatureImage(String featureImage) {
		this.featureImage = featureImage;
	}

	public List<String> getImages() {
		return images;
	}

	public void setImages(List<String> images) {
		this.images = images;
	}

	public String getSpecialImage() {
		return specialImage;
	}

	public void setSpecialImage(String specialImage) {
		this.specialImage = specialImage;
	}

	public String getSpecialDesc() {
		return specialDesc;
	}

	public void setSpecialDesc(String specialDesc) {
		this.specialDesc = specialDesc;
	}

	public BrandVO getBrand() {
		return brand;
	}

	public void setBrand(BrandVO brand) {
		this.brand = brand;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public BigDecimal getRawPrice() {
		return rawPrice;
	}

	public void setRawPrice(BigDecimal rawPrice) {
		this.rawPrice = rawPrice;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public Integer getPoint() {
		return point;
	}

	public void setPoint(Integer point) {
		this.point = point;
	}

	public Boolean getSoldOut() {
		return soldOut;
	}

	public void setSoldOut(Boolean soldOut) {
		this.soldOut = soldOut;
	}

	public String getStockWarn() {
		return stockWarn;
	}

	public void setStockWarn(String stockWarn) {
		this.stockWarn = stockWarn;
	}

	public Boolean getInvisible() {
		return invisible;
	}

	public void setInvisible(Boolean invisible) {
		this.invisible = invisible;
	}

	public Boolean getOffShelf() {
		return offShelf;
	}

	public void setOffShelf(Boolean offShelf) {
		this.offShelf = offShelf;
	}

	public List<Label> getLabels() {
		return labels;
	}

	public void setLabels(List<Label> labels) {
		this.labels = labels;
	}

	public List<String> getWaterMarkImage() {
		return waterMarkImage;
	}

	public void setWaterMarkImage(List<String> waterMarkImage) {
		this.waterMarkImage = waterMarkImage;
	}

	public Boolean getMonthSend() {
		return monthSend;
	}

	public void setMonthSend(Boolean monthSend) {
		this.monthSend = monthSend;
	}

	public FlowerMonthDistType getMonthSendDistType() {
		return monthSendDistType;
	}

	public void setMonthSendDistType(FlowerMonthDistType monthSendDistType) {
		this.monthSendDistType = monthSendDistType;
	}

	public Boolean getVipOnly() {
		return vipOnly;
	}

	public void setVipOnly(Boolean vipOnly) {
		this.vipOnly = vipOnly;
	}

	public Boolean getHasPresale() {
		return hasPresale;
	}

	public void setHasPresale(Boolean hasPresale) {
		this.hasPresale = hasPresale;
	}

	public String getUnSaleDesc() {
		return unSaleDesc;
	}

	public void setUnSaleDesc(String unSaleDesc) {
		this.unSaleDesc = unSaleDesc;
	}

	public Boolean getCombined() {
		return combined;
	}

	public void setCombined(Boolean combined) {
		this.combined = combined;
	}

	public boolean getCombination() {
		return combination;
	}

	public void setCombination(boolean combination) {
		this.combination = combination;
	}

	public List<ProductCampaignVO> getCampaigns() {
		return campaigns;
	}

	public void setCampaigns(List<ProductCampaignVO> campaigns) {
		this.campaigns = campaigns;
	}

	public Boolean getHasJit() {
		return hasJit;
	}

	public void setHasJit(Boolean hasJit) {
		this.hasJit = hasJit;
	}

	public BigDecimal getPointPrice() {
		return pointPrice;
	}

	public void setPointPrice(BigDecimal pointPrice) {
		this.pointPrice = pointPrice;
	}

	public Boolean getPointDeduction() {
		return pointDeduction;
	}

	public void setPointDeduction(Boolean pointDeduction) {
		this.pointDeduction = pointDeduction;
	}
	
	public Boolean getNewcomerTag() {
		return newcomerTag;
	}

	public void setNewcomerTag(Boolean newcomerTag) {
		this.newcomerTag = newcomerTag;
	}
	
	public Boolean getBirthdayGift() {
		return birthdayGift;
	}

	public void setBirthdayGift(Boolean birthdayGift) {
		this.birthdayGift = birthdayGift;
	}

	public Boolean getOnLineOnly() {
		return onLineOnly;
	}

	public void setOnLineOnly(Boolean onLineOnly) {
		this.onLineOnly = onLineOnly;
	}

	public Boolean getAllowCampaign() {
		return allowCampaign;
	}

	public void setAllowCampaign(Boolean allowCampaign) {
		this.allowCampaign = allowCampaign;
	}

	public Boolean getAllowCoupon() {
		return allowCoupon;
	}

	public void setAllowCoupon(Boolean allowCoupon) {
		this.allowCoupon = allowCoupon;
	}

	public BigDecimal getCommissionRate() {
		return commissionRate;
	}

	public void setCommissionRate(BigDecimal commissionRate) {
		this.commissionRate = commissionRate;
	}

	public BigDecimal getCommissionAmount() {
		return commissionAmount;
	}

	public void setCommissionAmount(BigDecimal commissionAmount) {
		this.commissionAmount = commissionAmount;
	}

	public BigDecimal getRefunds() {
		return refunds;
	}

	public void setRefunds(BigDecimal refunds) {
		this.refunds = refunds;
	}

	public String getRefundsName() {
		return refundsName;
	}

	public void setRefundsName(String refundsName) {
		this.refundsName = refundsName;
	}

	public VideoVO getVideo() {
		return video;
	}

	public void setVideo(VideoVO video) {
		this.video = video;
	}

	public String getMarkInfo() {
		return markInfo;
	}

	public void setMarkInfo(String markInfo) {
		this.markInfo = markInfo;
	}

	public String getDeliveryTag() {
		return deliveryTag;
	}

	public void setDeliveryTag(String deliveryTag) {
		this.deliveryTag = deliveryTag;
	}

	@Override
	public String toString() {
		return "SimpleProductVO{" +
				"isOversea=" + isOversea +
				", id='" + id + '\'' +
				", featureImage='" + featureImage + '\'' +
				", specialImage='" + specialImage + '\'' +
				", specialDesc='" + specialDesc + '\'' +
				", images=" + images +
				", brand=" + brand +
				", name='" + name + '\'' +
				", summary='" + summary + '\'' +
				", soldOut=" + soldOut +
				", stockWarn='" + stockWarn + '\'' +
				", invisible=" + invisible +
				", offShelf=" + offShelf +
				", labels=" + labels +
				", price=" + price +
				", rawPrice=" + rawPrice +
				", pointPrice=" + pointPrice +
				", point=" + point +
				", waterMarkImage=" + waterMarkImage +
				", discount=" + discount +
				", priceForecast=" + priceForecast +
				", rush=" + rush +
				", monthSend=" + monthSend +
				", monthSendDistType=" + monthSendDistType +
				", activityDesc='" + activityDesc + '\'' +
				", vipOnly=" + vipOnly +
				", foretell=" + foretell +
				", hasPresale=" + hasPresale +
				", customizable=" + customizable +
				", unSaleDesc='" + unSaleDesc + '\'' +
				", combined=" + combined +
				", combination=" + combination +
				", pointDeduction=" + pointDeduction +
				", campaigns=" + campaigns +
				", bigPic=" + bigPic +
				", hasJit=" + hasJit +
				", newcomerTag=" + newcomerTag +
				", birthdayGift=" + birthdayGift +
				", onLineOnly=" + onLineOnly +
				", allowCampaign=" + allowCampaign +
				", allowCoupon=" + allowCoupon +
				", commissionRate=" + commissionRate +
				", commissionAmount=" + commissionAmount +
				", refunds=" + refunds +
				", markInfo=" + markInfo +
				", deliveryTag=" + deliveryTag +
				'}';
	}

	/**
	 * 折扣标签
	 * 
	 * @author Yawei-wang
	 *
	 */
	public static class DiscVO implements Serializable {

		/**
		 * 是否为 vip 折扣，若为抢购价，则为 false
		 */
		private String vipLevel;

		/**
		 * App 专享价格
		 */
		private boolean appOnly;

		/**
		 * 是否为生日折扣
		 */
		private Boolean birthday;

		/**
		 * 第三方合作折扣
		 */
		private boolean thirdParty;

		public Boolean isBirthday() {
			return birthday;
		}

		public void setBirthday(Boolean birthday) {
			this.birthday = birthday;
		}

		public String getVipLevel() {
			return vipLevel;
		}

		public void setVipLevel(String vipLevel) {
			this.vipLevel = vipLevel;
		}

		public boolean isAppOnly() {
			return appOnly;
		}

		public void setAppOnly(boolean appOnly) {
			this.appOnly = appOnly;
		}

		public boolean getThirdParty() {
			return thirdParty;
		}

		public void setThirdParty(boolean thirdParty) {
			this.thirdParty = thirdParty;
		}

		@Override
		public String toString() {
			return "DiscVO{" +
					"vipLevel='" + vipLevel + '\'' +
					", appOnly=" + appOnly +
					", birthday=" + birthday +
					", thirdParty=" + thirdParty +
					'}';
		}
	}

	/**
	 * 预售价
	 * 
	 * @author Yawei-wang
	 *
	 */
	public static class PriceForecastVO implements Serializable {

		/**
		 * 开始时间
		 */
		private Timestamp since;
		/**
		 * 预告价名称：如 "圣诞狂欢季"
		 */
		private String name;
		/**
		 * 价格范围，若只有一种价格，则包含两个相同价格。
		 */
		private Collection<BigDecimal> range = new ArrayList<BigDecimal>();

		public Timestamp getSince() {
			return since;
		}

		public void setSince(Timestamp since) {
			this.since = since;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public Collection<BigDecimal> getRange() {
			return range;
		}

		public void setRange(Collection<BigDecimal> range) {
			this.range = range;
		}

		@Override
		public String toString() {
			return "PriceForecastVO [since =" + since + ", name =" + name + ", range =" + range + "]";
		}

	}

	/**
	 * 大图
	 * 
	 * @author Yawei-wang
	 *
	 */
	public static class BigPicVO implements Serializable {

		// 是否大图
		private Boolean isBigPic;

		// 大图link
		private String src;

		public Boolean getIsBigPic() {
			return isBigPic;
		}

		public void setIsBigPic(Boolean isBigPic) {
			this.isBigPic = isBigPic;
		}

		public String getSrc() {
			return src;
		}

		public void setSrc(String src) {
			this.src = src;
		}

		@Override
		public String toString() {
			return "BigPicVO [isBigPic =" + isBigPic + ", src =" + src + "]";
		}
	}

}
