package com.thebeastshop.support.vo.product;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 商品规格和可用组合
 *
 * @author Paul-xiong
 */
public class ProductVariantVO implements Serializable {
    private static final long serialVersionUID = 3587558603758618747L;
    private Collection<ProductDimensionVO> dimensions = new ArrayList<ProductDimensionVO>();
    private Collection<SpvVO> spvs = new ArrayList<SpvVO>();
    private Collection<ProductDimensionGroup> dimensionGroup = new ArrayList<>();
    private List<String> waterMarkImage;

    public ProductVariantVO() {
        super();
    }

    public Collection<ProductDimensionVO> getDimensions() {
        return dimensions;
    }

    public void setDimensions(Collection<ProductDimensionVO> dimensions) {
        this.dimensions = dimensions;
    }

    public Collection<SpvVO> getSpvs() {
        return spvs;
    }

    public void setSpvs(Collection<SpvVO> spvs) {
        this.spvs = spvs;
    }

    public Collection<ProductDimensionGroup> getDimensionGroup() {
        return dimensionGroup;
    }

    public void setDimensionGroup(Collection<ProductDimensionGroup> dimensionGroup) {
        this.dimensionGroup = dimensionGroup;
    }

    public List<String> getWaterMarkImage() {
        return waterMarkImage;
    }

    public void setWaterMarkImage(List<String> waterMarkImage) {
        this.waterMarkImage = waterMarkImage;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("dimensions", dimensions)
                .append("spvs", spvs)
                .append("dimensionGroup", dimensionGroup)
                .append("waterMarkImage", waterMarkImage)
                .toString();
    }

}
