/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.vo.order;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import com.google.common.collect.Lists;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.support.vo.logistics.DateUnitVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.logistics.TimeSlotVO;
import com.thebeastshop.support.vo.member.MemberAddressVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 预览订单
 *
 * @author Paul-xiong
 *
 */
public class OrderConfirmVO implements Serializable {
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 拼团编号
	 */

	private String grouponId;
	/**
	 * 礼品卡
	 */
	private List<GiftCardVO> giftCards;

	/**
	 * 价格
	 */
	private BigDecimal price;

	/**
	 * 促销价格
	 */
	private BigDecimal promotionPrice;

	/**
	 * 购物返还金额
	 */
	private BigDecimal refunds;

	/**
	 * 返还基金活动名
	 */
	private String refundsName;

	/**
	 * 定制费用
	 */
	private BigDecimal charge;

	/**
	 * 商品包
	 */
	private Collection<CartProductPackVO> packs = Lists.newArrayList();

	/**
	 * 标签
	 */
	private Collection<Label> labels = Lists.newArrayList();

	/**
	 * 是否包含海外购商品
	 */
	private boolean hasOverseaProducts = false;

	/**
	 * 是否需要上传照片
	 */
	private boolean hasOverseaPhoto = false;

	/**
	 * 价格步骤
	 */
	private Collection<PriceStepVO> priceSteps;

	/**
	 * 招行支付价格步骤 IPOS
	 */
	private Collection<PriceStepVO> cmbPriceSteps;

	/**
	 * 是否需要地址
	 */
	private Boolean needAddress = Boolean.TRUE;

	/**
	 * 地址信息
	 */
	private MemberAddressVO address;

	/**
	 * 是否支持自选配置日期
	 * 默认不支持自选
	 */
	private Boolean hasDeliverable = Boolean.FALSE;


	/**
	 * 购物车中有商品是需要选配送日期，但是没有实际配送日期的提示。
	 */
	private String deliverableTips;

	/**
	 * 配送描述
	 */
	private String deliveryTip;

	/**
	 * 可配送日期
	 */
	private List<DateUnitVO> deliverableDates;

	/**
	 * 时段
	 */
	private List<TimeSlotVO> deliverableTimeSlots;


	/**
	 * 邮费
	 */
	private PostageVO postage;

	/**
	 * 是否可以使用生日折扣
	 */
	private BdayVO bday;

	/**
	 * 可用的支付方式
	 */
	private List<PaymentType> payMethods;

	/**
	 * 是否可以添加备注
	 */
	private Boolean canRemark;

	/**
	 * 订单业务类型
	 */
	private OrderBusinessType orderType = OrderBusinessType.NORMAL;

	/**
	 * 是否包含定制
	 */
	private Boolean customizable = Boolean.FALSE;

	/**
	 * 是否允许使用语音卡
	 */
	private Boolean voiceCard = Boolean.TRUE;

	/**
	 * 是否允许使用祝福卡
	 */
	private Boolean greetingCard = Boolean.TRUE;

	/**
	 * 是否允许提交
	 */
	private Boolean canSubmit = Boolean.TRUE;

	/**
	 * 积分抵扣
	 */
	private PointDeductVO pointDeduct;

	/**
	 * 联系电话
	 */
	private String contactPhone;

	/**
	 * 联系人
	 */
	private String contactPerson;

	/**
	 * 储值信息
	 */
	private AccountVO account;

	/**
	 * 基金
	 */
	private FundVO fund;

	/**
	 * 系统运费计算结果（经免邮等计算后的最终系统运费，20200731）
	 */
	private BigDecimal calDeliverPostageAmount;

	/*
	* 订单积分换购（2022Q4会员日临时活动）
	*/
	private OrderAdditionalVO orderAdditional;


	public List<GiftCardVO> getGiftCards() {
		return giftCards;
	}

	public void setGiftCards(List<GiftCardVO> giftCards) {
		this.giftCards = giftCards;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public BigDecimal getPromotionPrice() {
		return promotionPrice;
	}

	public void setPromotionPrice(BigDecimal promotionPrice) {
		this.promotionPrice = promotionPrice;
	}

	public BigDecimal getRefunds() {
		return refunds;
	}

	public void setRefunds(BigDecimal refunds) {
		this.refunds = refunds;
	}

	public String getRefundsName() {
		return refundsName;
	}

	public void setRefundsName(String refundsName) {
		this.refundsName = refundsName;
	}

	public Boolean getVoiceCard() {
		return voiceCard;
	}

	public void setVoiceCard(Boolean voiceCard) {
		this.voiceCard = voiceCard;
	}

	public Boolean getGreetingCard() {
		return greetingCard;
	}

	public void setGreetingCard(Boolean greetingCard) {
		this.greetingCard = greetingCard;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public Collection<CartProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(Collection<CartProductPackVO> packs) {
		this.packs = packs;
	}

	public boolean isHasOverseaProducts() {
		return hasOverseaProducts;
	}

	public void setHasOverseaProducts(boolean hasOverseaProducts) {
		this.hasOverseaProducts = hasOverseaProducts;
	}

	public Collection<PriceStepVO> getPriceSteps() {
		return priceSteps;
	}

	public void setPriceSteps(Collection<PriceStepVO> priceSteps) {
		this.priceSteps = priceSteps;
	}

	public Collection<PriceStepVO> getCmbPriceSteps() {
		return cmbPriceSteps;
	}

	public void setCmbPriceSteps(Collection<PriceStepVO> cmbPriceSteps) {
		this.cmbPriceSteps = cmbPriceSteps;
	}

	public Boolean getNeedAddress() {
		return needAddress;
	}

	public void setNeedAddress(Boolean needAddress) {
		this.needAddress = needAddress;
	}

	public MemberAddressVO getAddress() {
		return address;
	}

	public void setAddress(MemberAddressVO address) {
		this.address = address;
	}

	public String getDeliveryTip() {
		return deliveryTip;
	}

	public void setDeliveryTip(String deliveryTip) {
		this.deliveryTip = deliveryTip;
	}

	public List<DateUnitVO> getDeliverableDates() {
		return deliverableDates;
	}

	public void setDeliverableDates(List<DateUnitVO> deliverableDates) {
		this.deliverableDates = deliverableDates;
	}

	public List<TimeSlotVO> getDeliverableTimeSlots() {
		return deliverableTimeSlots;
	}

	public void setDeliverableTimeSlots(List<TimeSlotVO> deliverableTimeSlots) {
		this.deliverableTimeSlots = deliverableTimeSlots;
	}

	public BdayVO getBday() {
		return bday;
	}

	public void setBday(BdayVO bday) {
		this.bday = bday;
	}

	public Collection<Label> getLabels() {
		return labels;
	}

	public void setLabels(Collection<Label> labels) {
		this.labels = labels;
	}

	public PostageVO getPostage() {
		return postage;
	}

	public void setPostage(PostageVO postage) {
		this.postage = postage;
	}

	public List<PaymentType> getPayMethods() {
		return payMethods;
	}

	public void setPayMethods(List<PaymentType> payMethods) {
		this.payMethods = payMethods;
	}

	public Boolean getCanRemark() {
		return canRemark;
	}

	public void setCanRemark(Boolean canRemark) {
		this.canRemark = canRemark;
	}

	public BigDecimal getCharge() {
		return charge;
	}

	public void setCharge(BigDecimal charge) {
		this.charge = charge;
	}

	public String getGrouponId() {
		return grouponId;
	}

	public void setGrouponId(String grouponId) {
		this.grouponId = grouponId;
	}

	public OrderBusinessType getOrderType() {
		return orderType;
	}

	public void setOrderType(OrderBusinessType orderType) {
		this.orderType = orderType;
	}

	public Boolean getCustomizable() {
		return customizable;
	}

	public void setCustomizable(Boolean customizable) {
		this.customizable = customizable;
	}

	public Boolean getCanSubmit() {
		return canSubmit;
	}

	public void setCanSubmit(Boolean canSubmit) {
		this.canSubmit = canSubmit;
	}

	public boolean isHasOverseaPhoto() {
		return hasOverseaPhoto;
	}

	public void setHasOverseaPhoto(boolean hasOverseaPhoto) {
		this.hasOverseaPhoto = hasOverseaPhoto;
	}

	public String getContactPhone() {
		return contactPhone;
	}

	public void setContactPhone(String contactPhone) {
		this.contactPhone = contactPhone;
	}

	public String getContactPerson() {
		return contactPerson;
	}

	public void setContactPerson(String contactPerson) {
		this.contactPerson = contactPerson;
	}

	public PointDeductVO getPointDeduct() {
		return pointDeduct;
	}

	public void setPointDeduct(PointDeductVO pointDeduct) {
		this.pointDeduct = pointDeduct;
	}

	public AccountVO getAccount() {
		return account;
	}

	public void setAccount(AccountVO account) {
		this.account = account;
	}

	public FundVO getFund() {
		return fund;
	}

	public void setFund(FundVO fund) {
		this.fund = fund;
	}

	public BigDecimal getCalDeliverPostageAmount() {
		return calDeliverPostageAmount;
	}

	public void setCalDeliverPostageAmount(BigDecimal calDeliverPostageAmount) {
		this.calDeliverPostageAmount = calDeliverPostageAmount;
	}

	public String getDeliverableTips() {
		return deliverableTips;
	}

	public void setDeliverableTips(String deliverableTips) {
		this.deliverableTips = deliverableTips;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this)
				.append("grouponId", grouponId)
				.append("giftCards", giftCards)
				.append("price", price)
				.append("promotionPrice", promotionPrice)
				.append("charge", charge)
				.append("packs", packs)
				.append("labels", labels)
				.append("hasOverseaProducts", hasOverseaProducts)
				.append("hasOverseaPhoto", hasOverseaPhoto)
				.append("priceSteps", priceSteps)
				.append("needAddress", needAddress)
				.append("address", address)
				.append("hasDeliverable", hasDeliverable)
				.append("deliverableTips", deliverableTips)
				.append("deliveryTip", deliveryTip)
				.append("deliverableDates", deliverableDates)
				.append("deliverableTimeSlots", deliverableTimeSlots)
				.append("postage", postage)
				.append("bday", bday)
				.append("payMethods", payMethods)
				.append("canRemark", canRemark)
				.append("orderType", orderType)
				.append("customizable", customizable)
				.append("voiceCard", voiceCard)
				.append("canSubmit", canSubmit)
				.append("contactPhone", contactPhone)
				.append("contactPerson", contactPerson)
				.append("pointDeduct", pointDeduct)
				.append("account", account)
				.append("fund", fund)
				.append("deliverAmount", calDeliverPostageAmount)
				.append("orderAdditional", orderAdditional)
				.toString();
	}

	public Boolean getHasDeliverable() {
		return hasDeliverable;
	}

	public void setHasDeliverable(Boolean hasDeliverable) {
		this.hasDeliverable = hasDeliverable;
	}

	public OrderAdditionalVO getOrderAdditional() {
		return orderAdditional;
	}

	public void setOrderAdditional(OrderAdditionalVO orderAdditional) {
		this.orderAdditional = orderAdditional;
	}


	/**
	 * 生日折扣
	 *
	 * @author Paul-xiong
	 *
	 */
	public static class BdayVO implements Serializable {

		/**
		 *
		 */
		private static final long serialVersionUID = 1L;

		/**
		 * 是否在生日折扣可以使用的期间内
		 */
		private boolean within;

		/**
		 * 今年是否已经使用过
		 */
		private boolean used;

		/**
		 * 折扣率
		 */
		private BigDecimal ratio;

		/**
		 * 默认选中
		 */
		private boolean defaultSelected = true;

		/**
		 * 价格上限
		 */
		private BigDecimal priceLimit;

		/**
		 * 数量限制
		 */
		private int countLimit;


		public boolean isWithin() {
			return within;
		}

		public void setWithin(boolean within) {
			this.within = within;
		}

		public boolean isUsed() {
			return used;
		}

		public void setUsed(boolean used) {
			this.used = used;
		}

		public BigDecimal getRatio() {
			return ratio;
		}

		public void setRatio(BigDecimal ratio) {
			this.ratio = ratio;
		}

		public boolean isDefaultSelected() {
			return defaultSelected;
		}

		public void setDefaultSelected(boolean defaultSelected) {
			this.defaultSelected = defaultSelected;
		}

		public BigDecimal getPriceLimit() {
			return priceLimit;
		}

		public void setPriceLimit(BigDecimal priceLimit) {
			this.priceLimit = priceLimit;
		}

		public int getCountLimit() {
			return countLimit;
		}

		public void setCountLimit(int countLimit) {
			this.countLimit = countLimit;
		}

		@Override
		public String toString() {
			return new ToStringBuilder(this)
					.append("within", within)
					.append("used", used)
					.append("ratio", ratio)
					.append("priceLimit", priceLimit)
					.append("countLimit", countLimit)
					.append("defaultSelected", defaultSelected)
					.toString();
		}
	}

	/**
	 * 积分抵扣
	 *
	 * @author Paul-xiong
	 *
	 */
	public static class PointDeductVO implements Serializable {

		/**
		 *
		 */
		private static final long serialVersionUID = 1L;
		/**
		 * 是否在生日折扣可以使用的期间内
		 */
		private boolean canUse=false;
		/**
		 * 今年是否已经使用过
		 */
		private Integer point;
		/**
		 * 折扣率
		 */
		private BigDecimal deductPrice;

		public boolean isCanUse() {
			return canUse;
		}

		public void setCanUse(boolean canUse) {
			this.canUse = canUse;
		}

		public Integer getPoint() {
			return point;
		}

		public void setPoint(Integer point) {
			this.point = point;
		}

		public BigDecimal getDeductPrice() {
			return deductPrice;
		}

		public void setDeductPrice(BigDecimal deductPrice) {
			this.deductPrice = deductPrice;
		}

		@Override
		public String toString() {
			return new ToStringBuilder(this)
					.append("canUse", canUse)
					.append("point", point)
					.append("deductPrice", deductPrice)
					.toString();
		}
	}

	/**
	 * 预存款
	 */
	public static class AccountVO implements Serializable {

		/**
		 *
		 */
		private static final long serialVersionUID = 1L;

		/**
		 * 余额
		 */
		private BigDecimal balance;

		/**
		 * 能否使用
		 */
		private Boolean usable = true;

		public BigDecimal getBalance() {
			return balance;
		}

		public void setBalance(BigDecimal balance) {
			this.balance = balance;
		}

		public Boolean getUsable() {
			return usable;
		}

		public void setUsable(Boolean usable) {
			this.usable = usable;
		}

		@Override
		public String toString() {
			return new ToStringBuilder(this)
					.append("balance", balance)
					.append("usable", usable).toString();
		}
	}

	/**
	 * 基金
	 */
	public static class FundVO implements Serializable{

		private static final long serialVersionUID = 1L;

		/**
		 * 余额
		 */
		private BigDecimal balance;

		/**
		 * 能否使用
		 */
		private Boolean usable = true;

		public BigDecimal getBalance() {
			return balance;
		}

		public void setBalance(BigDecimal balance) {
			this.balance = balance;
		}

		public Boolean getUsable() {
			return usable;
		}

		public void setUsable(Boolean usable) {
			this.usable = usable;
		}

		@Override
		public String toString() {
			return new ToStringBuilder(this)
					.append("balance", balance)
					.append("usable", usable).toString();
		}

	}


}