package com.thebeastshop.support.vo.order;

import com.thebeastshop.support.enums.OrderCardType;

import java.io.Serializable;

/**
 * 订单卡片
 * Created by feilong.gao on 2017/5/9.
 */
public class OrderCard implements Serializable {
    private static final long serialVersionUID = -1502658380540826583L;

    /**
     * 卡片类型，0不需要1空白2代写
     */
    private OrderCardType type = OrderCardType.NONE;

    /**
     * 卡片抬头信息
     */
    private String to;
    /**
     * 卡片正文
     */
    private String content;

    /**
     * 卡片落款信息
     */
    private String from;

    /**
     * 日期（一个普通展示字段，无业务意义）
     */
    private String date;

    /**
     * 标签（一个普通展示字段，无业务意义）
     */
    private String label;

    /**
     * 数量
     */
    private Integer count = 0;

   public OrderCardType getType() {
        return type;
    }

    public void setType(OrderCardType type) {
        this.type = type;
    }

    public String getTo() {
        return to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    @Override
    public String toString() {
        return "OrderCard{" +
                "type=" + type +
                ", to='" + to + '\'' +
                ", content='" + content + '\'' +
                ", from='" + from + '\'' +
                ", date='" + date + '\'' +
                ", label='" + label + '\'' +
                ", count=" + count +
                '}';
    }
}
