package com.thebeastshop.support.vo.benefit;

import com.thebeastshop.support.enums.benefit.BenefitStateEnum;
import com.thebeastshop.support.file.FileConstant;

import java.io.Serializable;
import java.util.List;

/**
 * Created by feilong.gao on 2017/4/17.
 */
public class BenefitVO implements Serializable {
    private static final long serialVersionUID = 4311283842466489439L;
    //特权id
    private Integer id;
    //特权类型
    private Integer benefitType;
    //特权图标
    private String icon;
    //特权图标2
    private String icon2;
    //特效点击效果图标
    private String pressedIcon;
    //特权详情图片
    private String detailIcon;
    //名称
    private String name;
    //特权状态
    private StateVO state;
    //是否会在记录里展示
    private Boolean enumerable = true;
    //是否需要手动兑换
    private Boolean redeemable = false;
    //权益使用次数限制
    private BenefitQuota quota;
    //特权描述
    private List<String> briefDesc;
    //特权礼包详情
    private Object detailDesc;
    //PRE|VALID 链接
    private String link;
    //PRE|VALID 小程序链接
    private String mpLink;
    //link类型
    private String linkType;

    public static BenefitVO createSimpleBenefit(Integer id, Integer benefitType, String icon, String pressedIcon, String name) {
        BenefitVO benefitVO = new BenefitVO();
        benefitVO.setId(id);
        benefitVO.setBenefitType(benefitType);
        benefitVO.setIcon(FileConstant.BASE_URL + icon);
        benefitVO.setPressedIcon(FileConstant.BASE_URL + pressedIcon);
        benefitVO.setName(name);
        return benefitVO;
    }

    public static BenefitVO createVipBenefit(Integer id, Integer benefitType, String detailIcon, String name, BenefitStateEnum state, Boolean redeemable, Object detailDesc) {
        BenefitVO benefitVO = new BenefitVO();
        benefitVO.setId(id);
        benefitVO.setBenefitType(benefitType);
        benefitVO.setDetailIcon(FileConstant.BASE_URL + detailIcon);
        benefitVO.setName(name);
        benefitVO.setState(new StateVO(state));
        benefitVO.setRedeemable(redeemable);
        benefitVO.setDetailDesc(detailDesc);
        return benefitVO;
    }

    public static BenefitVO createVipBenefit(Integer id, Integer benefitType, String detailIcon, String name, StateVO state, Boolean redeemable, Object detailDesc) {
        BenefitVO benefitVO = new BenefitVO();
        benefitVO.setId(id);
        benefitVO.setBenefitType(benefitType);
        benefitVO.setDetailIcon(FileConstant.BASE_URL + detailIcon);
        benefitVO.setName(name);
        benefitVO.setState(state);
        benefitVO.setRedeemable(redeemable);
        benefitVO.setDetailDesc(detailDesc);
        return benefitVO;
    }

    public static BenefitVO createVipBenefit(Integer id, String detailIcon, String name, BenefitStateEnum state, Boolean redeemable, Object detailDesc, String link) {
        BenefitVO benefitVO = new BenefitVO();
        benefitVO.setId(id);
        benefitVO.setDetailIcon(FileConstant.BASE_URL + detailIcon);
        benefitVO.setName(name);
        benefitVO.setState(new StateVO(state));
        benefitVO.setRedeemable(redeemable);
        benefitVO.setDetailDesc(detailDesc);
        benefitVO.setLink(link);
        return benefitVO;
    }


    public static BenefitVO createVipBenefit(Integer id, String detailIcon, String name, StateVO state, Boolean redeemable, Object detailDesc, String link) {
        BenefitVO benefitVO = new BenefitVO();
        benefitVO.setId(id);
        benefitVO.setDetailIcon(FileConstant.BASE_URL + detailIcon);
        benefitVO.setName(name);
        benefitVO.setState(state);
        benefitVO.setRedeemable(redeemable);
        benefitVO.setDetailDesc(detailDesc);
        benefitVO.setLink(link);
        return benefitVO;
    }

    public static BenefitVO createVipBenefit(Integer id, String detailIcon, String name, BenefitStateEnum state, Boolean redeemable, Object detailDesc, String link,String linkType) {
        BenefitVO benefitVO = new BenefitVO();
        benefitVO.setId(id);
        benefitVO.setDetailIcon(FileConstant.BASE_URL + detailIcon);
        benefitVO.setName(name);
        benefitVO.setState(new StateVO(state));
        benefitVO.setRedeemable(redeemable);
        benefitVO.setDetailDesc(detailDesc);
        benefitVO.setLink(link);
        benefitVO.setLinkType(linkType);
        return benefitVO;
    }


    public static BenefitVO createVipBenefit(Integer id, String detailIcon, String name, StateVO state, Boolean redeemable, Object detailDesc, String link,String linkType) {
        BenefitVO benefitVO = new BenefitVO();
        benefitVO.setId(id);
        benefitVO.setDetailIcon(FileConstant.BASE_URL + detailIcon);
        benefitVO.setName(name);
        benefitVO.setState(state);
        benefitVO.setRedeemable(redeemable);
        benefitVO.setDetailDesc(detailDesc);
        benefitVO.setLink(link);
        benefitVO.setLinkType(linkType);
        return benefitVO;
    }

    public static BenefitVO createMyBenefit(Integer id, String icon, String name, StateVO state, Boolean redeemable, BenefitQuota quota, List<String> briefDesc) {
        BenefitVO benefitVO = new BenefitVO();
        benefitVO.setId(id);
        benefitVO.setDetailIcon(FileConstant.BASE_URL + icon);
        benefitVO.setName(name);
        benefitVO.setState(state);
        benefitVO.setRedeemable(redeemable);
        benefitVO.setQuota(quota);
        benefitVO.setBriefDesc(briefDesc);
        return benefitVO;
    }

    public void setLinkInfo(String linkType, String link,String mpLink){
        this.linkType = linkType;
        this.link = link;
        this.mpLink = mpLink;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getBenefitType() {
        return benefitType;
    }

    public void setBenefitType(Integer benefitType) {
        this.benefitType = benefitType;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon2() {
        return icon2;
    }

    public void setIcon2(String icon2) {
        this.icon2 = icon2;
    }

    public String getPressedIcon() {
        return pressedIcon;
    }

    public void setPressedIcon(String pressedIcon) {
        this.pressedIcon = pressedIcon;
    }

    public String getDetailIcon() {
        return detailIcon;
    }

    public void setDetailIcon(String detailIcon) {
        this.detailIcon = detailIcon;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StateVO getState() {
        return state;
    }

    public void setState(StateVO state) {
        this.state = state;
    }

    public Boolean getEnumerable() {
        return enumerable;
    }

    public void setEnumerable(Boolean enumerable) {
        this.enumerable = enumerable;
    }

    public Boolean getRedeemable() {
        return redeemable;
    }

    public void setRedeemable(Boolean redeemable) {
        this.redeemable = redeemable;
    }

    public BenefitQuota getQuota() {
        return quota;
    }

    public void setQuota(BenefitQuota quota) {
        this.quota = quota;
    }

    public List<String> getBriefDesc() {
        return briefDesc;
    }

    public void setBriefDesc(List<String> briefDesc) {
        this.briefDesc = briefDesc;
    }

    public void setDetailDesc(Object detailDesc) {
        this.detailDesc = detailDesc;
    }

    public Object getDetailDesc() {
        return detailDesc;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getMpLink() {
        return mpLink;
    }

    public void setMpLink(String mpLink) {
        this.mpLink = mpLink;
    }

    public String getLinkType() {
        return linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    @Override
    public String toString() {
        return "BenefitVO{" +
                "id=" + id +
                ", benefitType=" + benefitType +
                ", icon='" + icon + '\'' +
                ", icon2='" + icon2 + '\'' +
                ", pressedIcon='" + pressedIcon + '\'' +
                ", detailIcon='" + detailIcon + '\'' +
                ", name='" + name + '\'' +
                ", state=" + state +
                ", enumerable=" + enumerable +
                ", redeemable=" + redeemable +
                ", quota=" + quota +
                ", briefDesc=" + briefDesc +
                ", detailDesc=" + detailDesc +
                ", link='" + link + '\'' +
                ", mpLink='" + mpLink + '\'' +
                ", linkType='" + linkType + '\'' +
                '}';
    }
}

