package com.thebeastshop.support.page;

import java.util.Collection;
import java.util.LinkedList;

public class Page<T> extends Pagination {
    private Collection<T> items = new LinkedList<T>();

    public Page() {
    }

    public Page(Pagination pagination) {
        super(pagination);
    }

    public Collection<T> getItems() {
        return items;
    }

    public Page<T> addItem(T obj) {
        items.add(obj);
        return this;
    }

    public void setItems(Collection<T> items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "Page [items=" + items + ", super=" + super.toString() + "]";
    }

}
