package com.thebeastshop.support.enums.benefit;

/**
 * 领取按钮枚举
 * Created by feilong.gao on 2016/12/14.
 */
public enum ReminderBtnEnum {

    LEVEL_BTN("立即领取",1,"等级礼包领取"),
    BIRTHDAY_BTN("去设置",2,"生日礼包按钮-去设置"),
    WELFARE_BTN("立即领取",4,"免邮福利-领取"),
    KAU_CIM_BIN("去求签",5,"求签福利跳转"),
    BIRTHDAY_ACTIVATION_BIN("立即激活",11,"生日到店礼-去激活"),
    ;

    private String name;
    private Integer privilegeTypeId;
    private String desc;

    private ReminderBtnEnum(String name, Integer privilegeTypeId,String desc){
        this.name = name;
        this.privilegeTypeId = privilegeTypeId;
        this.desc = desc;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getPrivilegeTypeId() {
        return privilegeTypeId;
    }

    public static String getBtnTextByPrivilegeTypeId(Integer privilegeTypeId){
        for(ReminderBtnEnum btnEnum : ReminderBtnEnum.values()){
            if(btnEnum.getPrivilegeTypeId().equals(privilegeTypeId)){
                return btnEnum.getName();
            }
        }
        return null;
    }
}
