package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.Type;

/**
 * 注册来源
 * 
 * @author Paul-xiong
 *
 */
public enum RegisterSource implements Type{
	UNKNOWN(0, "其他"),
	SHOP(1, "实体店"),
	PC(2, "官网"),
	WEIXIN(3, "微信"),
	WEIBO(4, "微博"),
	APP(5, "移动平台"),
	QQ(6, "QQ"),
	WEIXIN_APP(8, "微信开放平台");
	
	private final int id;
	private final String name;

	RegisterSource(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}
	
}
