package com.thebeastshop.support.enums;

import com.google.common.collect.Lists;
import com.thebeastshop.support.vo.member.LevelPointVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 积分等级枚举
 * Created by feilong.gao on 2017/1/3.
 */
public enum PointLevel {

    NORMAL(-1, "注册用户", BigDecimal.ZERO),
    VIP(0, "松鼠会员", BigDecimal.ONE),
    VIP2(1, "小猫会员", new BigDecimal("5000")),
    VIP3(2, "老虎会员", new BigDecimal("10000")),
    VIP4(3, "大象会员", new BigDecimal("50000")),
    ;

    private int level;
    private String name;
    private BigDecimal minPoint;


    private PointLevel(int level,String name,BigDecimal minPoint){
        this.level = level;
        this.name = name;
        this.minPoint = minPoint;
    }

    public int getLevel() {
        return level;
    }

    public String getName() {
        return name;
    }

    public BigDecimal getMinPoint() {
        return minPoint;
    }


    /**
     * 获取当前等级的等级积分信息
     * @return
     */
    public static LevelPointVO getLevelPointByLevel(int level){
        for(PointLevel value :PointLevel.values()){
            if(value.getLevel()==level){
                LevelPointVO levelPointVO = new LevelPointVO();
                levelPointVO.setLevel(value.getLevel());
                levelPointVO.setName(value.getName());
                levelPointVO.setMinPoint(value.getMinPoint());
                return levelPointVO;
            }
        }
        return null;
    }


    /**
     * 获取所有的等级积分
     * @return
     */
    public static List<LevelPointVO> getAllLevelPoint(){
        List<LevelPointVO> list = Lists.newArrayList();
        for(PointLevel value :PointLevel.values()){
            LevelPointVO levelPointVO = new LevelPointVO();
            levelPointVO.setLevel(value.getLevel());
            levelPointVO.setName(value.getName());
            levelPointVO.setMinPoint(value.getMinPoint());
            list.add(levelPointVO);
        }
        return list;
    }
}
