package com.thebeastshop.support.enums;

/**
 * Created by feilong.gao on 2017/2/21.
 */
public enum OrderBusinessType {

	/**
	 * 普通订单
	 */
	NORMAL("01", "普通订单"),

	MONTHLY_FLOWER("02", "鲜花月送订单"),

	CUSTOMIZE("03", "含定制商品订单"),

	RECIPE_CUSTOMIZE("05", "定制配方商品订单"),

	SPD("06", "浦发兑换订单"),

	FURNITURE("07", "大家具订单"),

	JBR("08", "井柏然圣诞集赞订单"),

	EXCHANGE("09", "积分兑换"),

	GROUPON("10", "团购"),

	DEPOSIT("11", "定金"),

	FINAL("12", "尾款"),
	
	CLASSROOM("13", "野兽课堂"),
	
	BDAYGIFT("14", "生日礼"),

	LADDER_BUY("16", "阶梯购"),

	WECHAT_GIFT("17", "微信送礼");

	private String code;
	private String desc;

	OrderBusinessType(String code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	/**
	 * 获取Code
	 * 
	 * @return
	 */
	public String getCode() {
		return code;
	}

	/**
	 * 获取描述
	 * 
	 * @return
	 */
	public String getDesc() {
		return desc;
	}

	/**
	 * 根据Code获取描述
	 * 
	 * @param code
	 * @return
	 */
	public static String getDesc(Integer code) {
		for (OrderBusinessType value : OrderBusinessType.values()) {
			if (value.getCode().equals(code)) {
				return value.getDesc();
			}
		}
		return "";
	}
}
