package com.thebeastshop.support.vo.redenvelope;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 红包配置对象
 * 用于初始化一个红包
 * Created by feilong.gao on 2017/2/13.
 */
public class RedEnvelopeConfig implements Serializable {

    private static final long serialVersionUID = 6199928880627454849L;

    /**
     * 模板id
     */
    private Integer templateId;
    /**
     * 模板类型
     */
    private Integer templateType;

    /**
     * 活动类型
     */
    private String activityType;
    /**
     * 红包类型
     */
    private Integer redType;
    /**
     * 红包总额
     */
    private Integer totalCutPrice;
    /**
     * 红包总数
     */
    private Integer redTotalNum;
    /**
     * 奖品组
     */
    private List<RedPrize> redGroup;

    /**
     * 奖品分档
     */
    private List<RedPrizePool> redPoolGroup;
    /**
     * 活动开始时间
     */
    private Date reStartTime;
    /**
     * 活动结束时间
     */
    private Date reEndTime;

    public Integer getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public Integer getRedType() {
        return redType;
    }

    public void setRedType(Integer redType) {
        this.redType = redType;
    }

    public Integer getTotalCutPrice() {
        return totalCutPrice;
    }

    public void setTotalCutPrice(Integer totalCutPrice) {
        this.totalCutPrice = totalCutPrice;
    }

    public Integer getRedTotalNum() {
        return redTotalNum;
    }

    public void setRedTotalNum(Integer redTotalNum) {
        this.redTotalNum = redTotalNum;
    }

    public List<RedPrize> getRedGroup() {
        return redGroup;
    }

    public void setRedGroup(List<RedPrize> redGroup) {
        this.redGroup = redGroup;
    }

    public List<RedPrizePool> getRedPoolGroup() {
        return redPoolGroup;
    }

    public void setRedPoolGroup(List<RedPrizePool> redPoolGroup) {
        this.redPoolGroup = redPoolGroup;
    }

    public Date getReStartTime() {
        return reStartTime;
    }

    public void setReStartTime(Date reStartTime) {
        this.reStartTime = reStartTime;
    }

    public Date getReEndTime() {
        return reEndTime;
    }

    public void setReEndTime(Date reEndTime) {
        this.reEndTime = reEndTime;
    }
}
