package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.flowerMonth.FlowerMonthDistType;
import com.thebeastshop.support.vo.product.SimpleProductVO.DiscVO;
import com.thebeastshop.support.vo.product.SimpleProductVO.PriceForecastVO;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;
import org.apache.commons.collections.CollectionUtils;

/**
 * 商品详情
 *
 * @author Paul-xiong
 */
public class ProductVO implements Serializable {

    private static final long serialVersionUID = 5874380718123289421L;

    /********** 基本信息 **********/
    private String productId;                                    //商品id
    private List<VideoVO> videos;                                //视频列表
    private List<WaterMarkVo> waterMarkVO;                        //水印列表

    private Map<Integer, WaterMarkVo> waterMarkIndexMap;                        //水印Index列表

    private List<ProductBadgeVO> badges = new ArrayList<ProductBadgeVO>();    //徽章列表
    private List<PriceTagVO> priceTags = new ArrayList<PriceTagVO>();    //价格标签列表（代替原有discount）
    private List<ProductTipVO> tips = new ArrayList<ProductTipVO>();        //提示列表
    private StrikePriceTagVO strikePriceTag;                    //到手价标签对象
    private ProductVariantVO variant = new ProductVariantVO();    //规格对象（重要对象）
    private ProductShareVO share = new ProductShareVO();        //分享对象

    @JsonIgnore
    private SimpleProductVO raw = new SimpleProductVO();        //商品基础信息对象（不再序列化这个raw）
    private PreSellVO presell;                                    //预售对象，若不是预售，则为 null
    private PriceForecastVO priceForecast;                        //价格预告对象
    private DownPaymentVO downPayment;                            //定金对象
    private GrouponVO groupon;                                    //团购对象
    private PrevueVO prevue;                                    //预告对象
    private ArrivalReminderVO arrival = new ArrivalReminderVO();//到货提醒对象

    /********** 各种标记 **********/
    private Boolean legacyDetails = false;                        //是否旧版本数据
    private boolean needVerifyAddress = false;                    //是否需要验证地址
    private Boolean favorited = false;                            //是否已收藏
    private Boolean furniture = false;                            //是否大家具
    private Boolean canCustomCard;                                //是否可定制卡片
    private Boolean onLineOnly = false;                            //是否线上专享商品
    private Boolean isCoupon = false;                            //是否有可选优惠卷
    private Boolean buyable;                                    //是否可购买
    private Boolean useHTML = false;                            //该商品页是否使用HTML代替（用于应急场景）。定制商品为true
    private String htmlLink;                                    //商品页HTML跳转链接

    /********** 过时字段 **********/
    private Boolean monthSend = false;                            //是否月送鲜花
    private FlowerMonthDistType monthSendDistType = FlowerMonthDistType.EXPRESS;    //月送配送类型


    public ProductVO() {
        super();
    }

    public Boolean getFurniture() {
        return furniture;
    }

    public void setFurniture(Boolean furniture) {
        this.furniture = furniture;
    }

    public PrevueVO getPrevue() {
        return prevue;
    }

    public void setPrevue(PrevueVO prevue) {
        this.prevue = prevue;
    }

    public Boolean getLegacyDetails() {
        return legacyDetails;
    }

    public GrouponVO getGroupon() {
        return groupon;
    }

    public void setGroupon(GrouponVO groupon) {
        this.groupon = groupon;
    }

    public List<VideoVO> getVideos() {
        return videos;
    }

    public void setVideos(List<VideoVO> videos) {
        this.videos = videos;
    }

    public Boolean getBuyable() {
        return buyable;
    }

    public void setBuyable(Boolean buyable) {
        this.buyable = buyable;
    }

    public PriceForecastVO getPriceForecast() {
        return priceForecast;
    }

    public void setPriceForecast(PriceForecastVO priceForecast) {
        this.priceForecast = priceForecast;
    }

    public List<ProductBadgeVO> getBadges() {
        return badges;
    }

    public List<ProductTipVO> getTips() {
        return tips;
    }

    public ProductVariantVO getVariant() {
        return variant;
    }

    public Boolean getFavorited() {
        return favorited;
    }

    public ProductShareVO getShare() {
        return share;
    }

    public void setShare(ProductShareVO share) {
        this.share = share;
    }

    public void setFavorited(Boolean favorited) {
        this.favorited = favorited;
    }

    public boolean isNeedVerifyAddress() {
        return needVerifyAddress;
    }

    public void setNeedVerifyAddress(boolean needVerifyAddress) {
        this.needVerifyAddress = needVerifyAddress;
    }

    public void setBadges(List<ProductBadgeVO> badges) {
        this.badges = badges;
    }

    public void setTips(List<ProductTipVO> tips) {
        this.tips = tips;
    }

    public void setVariant(ProductVariantVO variant) {
        this.variant = variant;
    }

    public List<WaterMarkVo> getWaterMarkVO() {
        return waterMarkVO;
    }

    public void setWaterMarkVO(List<WaterMarkVo> waterMarkVO) {

        this.waterMarkVO = waterMarkVO;
        if(CollectionUtils.isNotEmpty(waterMarkVO)){
            waterMarkIndexMap = new HashMap<>(waterMarkVO.size());
            for (WaterMarkVo waterMarkVo : waterMarkVO) {
                waterMarkIndexMap.put(waterMarkVo.getIndex(), waterMarkVo);
            }
        }

    }

    public PreSellVO getPresell() {
        return presell;
    }

    public void setPresell(PreSellVO presell) {
        this.presell = presell;
    }

    public Boolean getUseHTML() {
        return useHTML;
    }

    public void setUseHTML(Boolean useHTML) {
        this.useHTML = useHTML;
    }

    public String getHtmlLink() {
        return htmlLink;
    }

    public void setHtmlLink(String htmlLink) {
        this.htmlLink = htmlLink;
    }

    public Boolean getMonthSend() {
        return monthSend;
    }

    public void setMonthSend(Boolean monthSend) {
        this.monthSend = monthSend;
    }

    public FlowerMonthDistType getMonthSendDistType() {
        return monthSendDistType;
    }

    public void setMonthSendDistType(FlowerMonthDistType monthSendDistType) {
        this.monthSendDistType = monthSendDistType;
    }

    public List<PriceTagVO> getPriceTags() {
        return priceTags;
    }

    public void setPriceTags(List<PriceTagVO> priceTags) {
        this.priceTags = priceTags;
    }

    public Boolean isLegacyDetails() {
        return legacyDetails;
    }

    public void setLegacyDetails(Boolean legacyDetails) {
        this.legacyDetails = legacyDetails;
    }

    public DownPaymentVO getDownPayment() {
        return downPayment;
    }

    public void setDownPayment(DownPaymentVO downPayment) {
        this.downPayment = downPayment;
    }

    public StrikePriceTagVO getStrikePriceTag() {
        return strikePriceTag;
    }

    public void setStrikePriceTag(StrikePriceTagVO strikePriceTag) {
        this.strikePriceTag = strikePriceTag;
    }

    public Boolean getOnLineOnly() {
        return onLineOnly;
    }

    public void setOnLineOnly(Boolean onLineOnly) {
        this.onLineOnly = onLineOnly;
    }

    public ArrivalReminderVO getArrival() {
        return arrival;
    }

    public void setArrival(ArrivalReminderVO arrival) {
        this.arrival = arrival;
    }

    public Boolean getIsCoupon() {
        return isCoupon;
    }

    public void setIsCoupon(Boolean isCoupon) {
        this.isCoupon = isCoupon;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Boolean getCanCustomCard() {
        return canCustomCard;
    }

    public void setCanCustomCard(Boolean canCustomCard) {
        this.canCustomCard = canCustomCard;
    }


    /********** 以下内容直接从raw里返回 **********/

    public ProductVO(SimpleProductVO raw) {
        this.raw = raw;
    }

    public Boolean getForetell() {
        return raw.getForetell();
    }

    public void setForetell(Boolean foretell) {
        raw.setForetell(foretell);
    }

    public Boolean getIsOversea() {
        return raw.getIsOversea();
    }

    public void setIsOversea(Boolean isOversea) {
        raw.setIsOversea(isOversea);
    }

    public Boolean getCustomizable() {
        return raw.getCustomizable();
    }

    public void setCustomizable(Boolean customizable) {
        raw.setCustomizable(customizable);
    }

    public boolean getCombination() {
        return raw.getCombination();
    }

    public void setCombination(boolean combination) {
        raw.setCombination(combination);
    }

    public DiscVO getDiscount() {
        return raw.getDiscount();
    }

    public void setDiscount(DiscVO discount) {
        raw.setDiscount(discount);
    }

    public String getFeatureImage() {
        return raw.getFeatureImage();
    }

    public void setFeatureImage(String featureImage) {
        raw.setFeatureImage(featureImage);
    }

    public String getSpecialImage() {
        return raw.getSpecialImage();
    }

    public void setSpecialImage(String specialImage) {
        raw.setSpecialImage(specialImage);
    }

    public String getSpecialDesc() {
        return raw.getSpecialDesc();
    }

    public void setSpecialDesc(String specialDesc) {
        raw.setSpecialDesc(specialDesc);
    }

    public String getId() {
        return raw.getId();
    }

    public BrandVO getBrand() {
        return raw.getBrand();
    }

    public String getName() {
        return raw.getName();
    }

    public String getSummary() {
        return raw.getSummary();
    }

    public BigDecimal getRawPrice() {
        return raw.getRawPrice();
    }

    public BigDecimal getPrice() {
        return raw.getPrice();
    }

    public Boolean getSoldOut() {
        return raw.getSoldOut();
    }

    public Boolean getInvisible() {
        return raw.getInvisible();
    }

    public void setInvisible(Boolean invisible) {
        raw.setInvisible(invisible);
    }

    public Boolean getOffShelf() {
        return raw.getOffShelf();
    }

    public void setOffShelf(Boolean offShelf) {
        raw.setOffShelf(offShelf);
    }

    public List<Label> getLabels() {
        return raw.getLabels();
    }

    public void setLabels(List<Label> labels) {
        raw.setLabels(labels);
    }

    public BigDecimal getCommissionRate() {
        return raw.getCommissionRate();
    }

    public BigDecimal getCommissionAmount() {
        return raw.getCommissionAmount();
    }

    public SimpleProductVO getRaw() {
        return raw;
    }

    public void setRaw(SimpleProductVO raw) {
        this.raw = raw;
    }

    public void setId(String id) {
        raw.setId(id);
    }

    public List<String> getImages() {
        return raw.getImages();
    }

    public void setImages(List<String> images) {
        raw.setImages(images);
    }

    public void setBrand(BrandVO brand) {
        raw.setBrand(brand);
    }

    public void setName(String name) {
        raw.setName(name);
    }

    public void setSummary(String summary) {
        raw.setSummary(summary);
    }

    public void setRawPrice(BigDecimal rawPrice) {
        raw.setRawPrice(rawPrice);
    }

    public void setPrice(BigDecimal price) {
        raw.setPrice(price);
    }

    public void setPointPrice(BigDecimal pointPrice) {
        raw.setPointPrice(pointPrice);
    }

    public BigDecimal getPointPrice() {
        return raw.getPointPrice();
    }

    public Boolean getPointDeduction() {
        return raw.getPointDeduction();
    }

    public void setPointDeduction(Boolean pointDeduction) {
        raw.setPointDeduction(pointDeduction);
    }

    public Integer getPoint() {
        return raw.getPoint();
    }

    public void setPoint(Integer point) {
        raw.setPoint(point);
    }

    public void setSoldOut(Boolean soldOut) {
        raw.setSoldOut(soldOut);
    }

    public Boolean getNewcomerTag() {
        return raw.getNewcomerTag();
    }

    public void setNewcomerTag(Boolean newcomerTag) {
        raw.setNewcomerTag(newcomerTag);
    }

    public void setWaterMarkIndexMap(Map<Integer, WaterMarkVo> waterMarkIndexMap) {
        this.waterMarkIndexMap = waterMarkIndexMap;
    }

    public Map<Integer, WaterMarkVo> getWaterMarkIndexMap() {
        return waterMarkIndexMap;
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("ProductVO{");
        sb.append("raw=").append(raw);
        sb.append(", badges=").append(badges);
        sb.append(", needVerifyAddress=").append(needVerifyAddress);
        sb.append(", tips=").append(tips);
        sb.append(", variant=").append(variant);
        sb.append(", share=").append(share);
        sb.append(", favorited=").append(favorited);
        sb.append(", useHTML=").append(useHTML);
        sb.append(", htmlLink=").append(htmlLink);
        sb.append(", presell=").append(presell);
        sb.append(", priceForecast=").append(priceForecast);
        sb.append(", buyable=").append(buyable);
        sb.append(", prevue=").append(prevue);
        sb.append(", arrival=").append(arrival);
        sb.append(", videos=").append(videos);
        sb.append(", priceTags=").append(priceTags);
        sb.append(", legacyDetails=").append(legacyDetails);
        sb.append(", furniture=").append(furniture);
        sb.append(", groupon=").append(groupon);
        sb.append(", downPayment=").append(downPayment);
        sb.append(", onLineOnly=").append(onLineOnly);
        sb.append('}');
        return sb.toString();
    }
}
