package com.thebeastshop.support.vo.product;

import com.thebeastshop.support.Label;
import com.thebeastshop.support.Link;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.vo.coupon.CouponVO;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商品基础信息(since1.8)
 *
 * @author WangYawei
 */
public class ProductListVO {
    private ProductDiscount productDiscount;
    private Page<SimpleProductVO> list;
    private Suggest suggest;
    private Banner banner;
    private Label label;
    private String tips;
    private Link jump;      //搜索直接跳转，用于搜索页搜索直达功能
    /**
     * 分享图片
     */
    private ShareImage shareImage;
    /**
     * 返礼信息
     */
    private List<ReturnGift> returnGifts;

    public Banner getBanner() {
        return banner;
    }

    public void setBanner(Banner banner) {
        this.banner = banner;
    }

    public ProductDiscount getProductDiscount() {
        return productDiscount;
    }

    public void setProductDiscount(ProductDiscount productDiscount) {
        this.productDiscount = productDiscount;
    }

    public Page<SimpleProductVO> getList() {
        return list;
    }

    public void setList(Page<SimpleProductVO> list) {
        this.list = list;
    }

    public Suggest getSuggest() {
        return suggest;
    }

    public void setSuggest(Suggest suggest) {
        this.suggest = suggest;
    }

    public Label getLabel() {
        return label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public String getTips() {
        return tips;
    }

    public void setTips(String tips) {
        this.tips = tips;
    }

    public Link getJump() {
        return jump;
    }

    public void setJump(Link jump) {
        this.jump = jump;
    }

    public ShareImage getShareImage() {
        return shareImage;
    }

    public void setShareImage(ShareImage shareImage) {
        this.shareImage = shareImage;
    }

    public List<ReturnGift> getReturnGifts() {
        return returnGifts;
    }

    public void setReturnGifts(List<ReturnGift> returnGifts) {
        this.returnGifts = returnGifts;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("productDiscount", productDiscount)
                .append("list", list)
                .append("suggest", suggest)
                .append("banner", banner)
                .append("label", label)
                .append("tips", tips)
                .append("jump", jump)
                .append("shareImage", shareImage)
                .append("returnGifts", returnGifts)
                .toString();
    }

    /**
     * 折扣
     *
     * @author WangYawei
     */

    public static class ProductDiscount implements Serializable {

        private BigDecimal ratio; // 折扣力度

        private String desc; // 一句话描述

        private String extendedDesc; // 如果有专享商品88折活动用{vipImage}间隔，如“大象会员9折丨含{vipImage}商品专享88折”

        private String linkText; // 享受专享88折时的右侧 “全部88折商品”

        private String link; // 全部专享商品对应的deeplink

        public BigDecimal getRatio() {
            return ratio;
        }

        public void setRatio(BigDecimal ratio) {
            this.ratio = ratio;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getExtendedDesc() {
            return extendedDesc;
        }

        public void setExtendedDesc(String extendedDesc) {
            this.extendedDesc = extendedDesc;
        }

        public String getLinkText() {
            return linkText;
        }

        public void setLinkText(String linkText) {
            this.linkText = linkText;
        }

        public String getLink() {
            return link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        @Override
        public String toString() {
            return "ProductDiscount [ratio =" + ratio + ", desc =" + desc + ", extendedDesc =" + extendedDesc
                    + ", linkText =" + linkText + ", link =" + link + "]";
        }

    }

    /**
     * 推荐since 2.1.0
     *
     * @author WangYawei
     */

    public static class Suggest implements Serializable {

        private String link; // 跳转链接

        private String keyword; // 关键字

        public String getLink() {
            return link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getKeyword() {
            return keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public String toString() {
            return "Suggest [link =" + link + ", keyword =" + keyword + "]";
        }

    }

    public static class Banner implements Serializable {

        private Integer width;

        private Integer height;

        private String src;

        private Link link;

        public Integer getWidth() {
            return width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Integer getHeight() {
            return height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public String getSrc() {
            return src;
        }

        public void setSrc(String src) {
            this.src = src;
        }

        public Link getLink() {
            return link;
        }

        public void setLink(Link link) {
            this.link = link;
        }

        @Override
        public String toString() {
            return new ToStringBuilder(this)
                    .append("width", width)
                    .append("height", height)
                    .append("src", src)
                    .append("link", link)
                    .toString();
        }
    }

    public static class ShareImage implements Serializable {

        private String miniShareImage;

        private String shoppingShareImage;

        public String getMiniShareImage() {
            return miniShareImage;
        }

        public void setMiniShareImage(String miniShareImage) {
            this.miniShareImage = miniShareImage;
        }

        public String getShoppingShareImage() {
            return shoppingShareImage;
        }

        public void setShoppingShareImage(String shoppingShareImage) {
            this.shoppingShareImage = shoppingShareImage;
        }

        @Override
        public String toString() {
            return new ToStringBuilder(this)
                    .append("miniShareImage", miniShareImage)
                    .append("shoppingShareImage", shoppingShareImage)
                    .toString();
        }
    }


    /**
     * 返礼对象
     */
    public static class ReturnGift implements Serializable {
        /**
         * 返礼条件提示
         */
        private String conditionTips;
        /**
         * 返礼类型： @com.thebeastshop.promotionAdapter.enums.RewardTypeEnum
         * TYPE_COUPON("1", "优惠券"),
         * TYPE_THIRD_COUPON("2", "第三方券"),
         * TYPE_PROD_BENEFITS("3", "商品权益"),
         * TYPE_POSTAGE_BENEFITS("4", "免邮权益"),
         * TYPE_LOTTERY("5", "抽奖次数"),
         */
        private String type;
        private CouponVO coupon;
        private SimpleProductVO simpleProduct;

        public String getConditionTips() {
            return conditionTips;
        }

        public void setConditionTips(String conditionTips) {
            this.conditionTips = conditionTips;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public CouponVO getCoupon() {
            return coupon;
        }

        public void setCoupon(CouponVO coupon) {
            this.coupon = coupon;
        }

        public SimpleProductVO getSimpleProduct() {
            return simpleProduct;
        }

        public void setSimpleProduct(SimpleProductVO simpleProduct) {
            this.simpleProduct = simpleProduct;
        }

        @Override
        public String toString() {
            return new ToStringBuilder(this)
                    .append("conditionTips", conditionTips)
                    .append("type", type)
                    .append("coupon", coupon)
                    .append("simpleProduct", simpleProduct)
                    .toString();
        }
    }
}
