/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.vo.order;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.vo.logistics.DateUnitVO;
import com.thebeastshop.support.vo.logistics.TimeSlotVO;
import com.thebeastshop.support.vo.member.MemberAddressVO;
import com.thebeastshop.support.vo.order.OrderSimpleVO.OrderStateVO;

/**
 * 订单详情vo
 *
 * @author Paul-xiong
 *
 */
public class OrderDetailVO {
	/**
	 * 订单基本信息
	 */
	private OrderSimpleVO raw = new OrderSimpleVO();
	/**
	 * 支付类型
	 */
	private PaymentVO payment;
	/**
	 * 订单的包裹信息
	 */
	private Collection<OrderParcelVO> packages;
	/**
	 * 价格步骤
	 */
	private Collection<PriceStepVO> priceSteps;
	/**
	 * 是否为匿名购买
	 */
	private boolean anonymous;
	/**
	 * 卡片内容
	 */
	private String card;
	/**
	 * 可配送日期
	 */
	private DateUnitVO deliverableDate;
	/**
	 * 时段
	 */
	private TimeSlotVO deliverableTimeSlot;
	/**
	 * 是否使用生日折扣
	 */
	private boolean useBdayDiscount;

	/**
	 * 订单备注
	 */
	private String remark;

	public OrderDetailVO() {
		super();
	}

	public OrderBusinessType getOrderType() {
		return raw.getOrderType();
	}

	public void setOrderType(OrderBusinessType orderType) {
		raw.setOrderType(orderType);
	}
	public List<PaymentType> getPayMethods() {
		return raw.getPayMethods();
	}

	public void setPayMethods(List<PaymentType> payMethods) {
		raw.setPayMethods(payMethods);
	}

	public MemberAddressVO getAddress() {
		return raw.getAddress();
	}

	public void setAddress(MemberAddressVO address) {
		raw.setAddress(address);
	}

	public boolean isHasOverseaProducts() {
		return raw.isHasOverseaProducts();
	}

	public void setHasOverseaProducts(boolean hasOverseaProducts) {
		raw.setHasOverseaProducts(hasOverseaProducts);
	}

	public OrderDetailVO(OrderSimpleVO raw) {
		super();
		this.raw = raw;
	}

	public String getId() {
		return raw.getId();
	}

	public void setId(String id) {
		raw.setId(id);
	}

	public OrderStateVO getState() {
		return raw.getState();
	}

	public void setState(OrderStateVO state) {
		raw.setState(state);
	}

	public long getPayExpireTime() {
		return raw.getPayExpireTime();
	}

	public void setPayExpireTime(long payExpireTime) {
		raw.setPayExpireTime(payExpireTime);
	}

	public Date getCreateTime() {
		return raw.getCreateTime();
	}
	public void setCreateTime(Date createTime) {
		raw.setCreateTime(createTime);
	}

	public BigDecimal getPrice() {
		return raw.getPrice();
	}

	public void setPrice(BigDecimal price) {
		raw.setPrice(price);
	}

	public PaymentVO getPayment() {
		return payment;
	}

	public void setPayment(PaymentVO payment) {
		this.payment = payment;
	}

	public Collection<OrderParcelVO> getPackages() {
		return packages;
	}

	public void setPackages(Collection<OrderParcelVO> packages) {
		this.packages = packages;
	}

	public Collection<PriceStepVO> getPriceSteps() {
		return priceSteps;
	}

	public void setPriceSteps(Collection<PriceStepVO> priceSteps) {
		this.priceSteps = priceSteps;
	}

	public boolean isAnonymous() {
		return anonymous;
	}

	public void setAnonymous(boolean anonymous) {
		this.anonymous = anonymous;
	}

	public String getCard() {
		return card;
	}

	public void setCard(String card) {
		this.card = card;
	}

	public boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}

	public DateUnitVO getDeliverableDate() {
		return deliverableDate;
	}

	public void setDeliverableDate(DateUnitVO deliverableDate) {
		this.deliverableDate = deliverableDate;
	}

	public TimeSlotVO getDeliverableTimeSlot() {
		return deliverableTimeSlot;
	}

	public void setDeliverableTimeSlot(TimeSlotVO deliverableTimeSlot) {
		this.deliverableTimeSlot = deliverableTimeSlot;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	@Override
	public String toString() {
		return "OrderDetailVO [raw=" + raw + ", payment=" + payment + ", packages=" + packages + ", priceSteps="
				+ priceSteps + ", anonymous=" + anonymous + ", card=" + card + ", deliverableDate=" + deliverableDate
				+ ", deliverableTimeSlot=" + deliverableTimeSlot + ", useBdayDiscount=" + useBdayDiscount
				+ ", remark=" + remark+ "]";
	}

	/**
	 * 支付类型
	 *
	 * @author Paul-xiong
	 *
	 */
	public static class PaymentVO {
		/**
		 * 枚举名
		 */
		private String type;
		/**
		 * 中文名
		 */
		private String name;

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		@Override
		public String toString() {
			return "PaymentVO [type=" + type + ", name=" + name + "]";
		}

	}

	/**
	 * 价格步骤
	 *
	 * @author Paul-xiong
	 *
	 */
	public static class PriceStepVO {
		/**
		 * 名字
		 */
		private String name;
		/**
		 * 价格
		 */
		private BigDecimal price;
		/**
		 * 描述
		 */
		private String desc;
		/**
		 * 步骤类型
		 */
		private Integer stepType;

		public PriceStepVO() {
			super();
		}

		public PriceStepVO(String name, BigDecimal price) {
			super();
			this.name = name;
			this.price = price;
		}

		public PriceStepVO(String name, BigDecimal price, String desc) {
			this(name, price);
			this.desc = desc;
		}

		public PriceStepVO(String name, BigDecimal price, Integer stepType) {
			this.name = name;
			this.price = price;
			this.stepType = stepType;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public void setPrice(BigDecimal price) {
			this.price = price;
		}

		public BigDecimal getPrice() {
			return price;
		}

		public Integer getStepType() {
			return stepType;
		}

		public void setStepType(Integer stepType) {
			this.stepType = stepType;
		}

		public String getDesc() {
			return desc;
		}

		public void setDesc(String desc) {
			this.desc = desc;
		}

		@Override
		public String toString() {
			return "PriceStepVO{" +
					"name='" + name + '\'' +
					", price=" + price +
					", desc='" + desc + '\'' +
					", stepType=" + stepType +
					'}';
		}
	}
}
