package com.thebeastshop.support.vo.flowerMonth;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 捆绑选项
 * @author GFL
 * @Date 2018/1/30 15:45.
 */
public class TiedChoiceVO implements Serializable{

    private static final long serialVersionUID = 8597112347334039548L;
    private String name;                   //名字
    private BigDecimal price;              //价格
    private String spvId;                  //捆绑商品spvid
    private Boolean soldOut;               //是否售罄:true 表示售罄

    public TiedChoiceVO(String name, BigDecimal price, String spvId, Boolean soldOut) {
        this.name = name;
        this.price = price;
        this.spvId = spvId;
        this.soldOut = soldOut;
    }

    public TiedChoiceVO() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getSpvId() {
        return spvId;
    }

    public void setSpvId(String spvId) {
        this.spvId = spvId;
    }

    public Boolean getSoldOut() {
        return soldOut;
    }

    public void setSoldOut(Boolean soldOut) {
        this.soldOut = soldOut;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("TiedChoice{");
        sb.append("name='").append(name).append('\'');
        sb.append(", price=").append(price);
        sb.append(", spvId='").append(spvId).append('\'');
        sb.append(", soldOut=").append(soldOut);
        sb.append('}');
        return sb.toString();
    }
}
