package com.thebeastshop.support.vo.exchange;

import com.google.common.collect.Lists;
import com.thebeastshop.support.enums.exchange.ExchangeGoodsClassify;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.List;

/**
 * @author feilong.gao
 * @Date 2018/12/13 14:32.
 * @Description 套券兑换商品
 */
public class ExchangeGroupCouponGoods extends ExchangeGoods {

    private String title;              //标题
    private String description;        //详细说明
    private String descImageUrl;       //详情图片
    private String note;               // 备注
    private List<ExchangeCoupon> subCoupons = Lists.newArrayList(); //套券的子优惠券

    public ExchangeGroupCouponGoods() {
        classify = ExchangeGoodsClassify.GROUP_COUPON;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescImageUrl() {
        return descImageUrl;
    }

    public void setDescImageUrl(String descImageUrl) {
        this.descImageUrl = descImageUrl;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public List<ExchangeCoupon> getSubCoupons() {
        return subCoupons;
    }

    public void setSubCoupons(List<ExchangeCoupon> subCoupons) {
        this.subCoupons = subCoupons;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("title", title)
                .append("description", description)
                .append("descImageUrl", descImageUrl)
                .append("note", note)
                .append("subCoupons", subCoupons)
                .toString();
    }
}
