package com.thebeastshop.support.vo.benefit;

import com.thebeastshop.support.enums.benefit.BenefitStateEnum;

import java.io.Serializable;

/**
 * Created by feilong.gao on 2017/4/20.
 */
public class StateVO implements Serializable {
    private static final long serialVersionUID = 8437404730259338456L;
    /**
     * 特权状态
     */
    private BenefitStateEnum type;
    /**
     * 特权描述
     */
    private String desc;

    public StateVO() {
    }

    ;

    public StateVO(BenefitStateEnum benefitStateEnum) {
        this.type = benefitStateEnum;
        this.desc = benefitStateEnum.getDesc();
    }

    public BenefitStateEnum getType() {
        return type;
    }

    public void setType(BenefitStateEnum type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("StateVO{");
        sb.append("type=").append(type);
        sb.append(", desc='").append(desc).append('\'');
        sb.append('}');
        return sb.toString();
    }


    /**
     *
     * @param privilegeTypeId @PrivilegTypeEnum.id 礼包离线id
     * @param status          0 启用 1 禁用 -1 即将上线
     * @param isRecieve       0 未领取 1 已领取  2 已过期 -1 未满足条件
     * @param action          1.显示 2:跳转 3:领取
     * @return
     */
    public static StateVO getStateVO(Integer privilegeTypeId, Integer status, Integer isRecieve, Integer action) {
        return getStateVO(privilegeTypeId, status, isRecieve, action,"");
    }


    /**
     *
     * @param privilegeTypeId @PrivilegTypeEnum.id 礼包离线id
     * @param status          0 启用 1 禁用 -1 即将上线
     * @param isRecieve       0 未领取 1 已领取  2 已过期 -1 未满足条件
     * @param action          1.显示 2:跳转 3:领取
     * @return
     */
    public static StateVO getStateVO(Integer privilegeTypeId, Integer status, Integer isRecieve, Integer action,String btnText) {
        StateVO stateVO = new StateVO();
        switch (action) {
            case 1:
                stateVO.setType(BenefitStateEnum.USED);
                break;
            case 2:
                if (-1 == status) {
                    stateVO.setType(BenefitStateEnum.INVALID);
                    stateVO.setDesc("即将上线，敬请期待");
                } else if (0 == status) {
                    stateVO.setType(BenefitStateEnum.VALID);
                    if (5 == privilegeTypeId) {
                        stateVO.setDesc("去求签");
                    } else if (6 == privilegeTypeId) {
                        stateVO.setDesc("去看看");
                    } else {
                        stateVO.setDesc(btnText);
                    }
                }
                break;
            case 3:
                if (0 == isRecieve) {
                    stateVO.setType(BenefitStateEnum.VALID);
                    if (1 == privilegeTypeId) {
                        stateVO.setDesc("领取礼包");
                    } else if (4 == privilegeTypeId) {
                        stateVO.setDesc("领取本月福利");
                    }
                } else if (1 == isRecieve) {
                    stateVO.setType(BenefitStateEnum.USED);
                    if (1 == privilegeTypeId) {
                        stateVO.setDesc("礼包已领取");
                    } else if (4 == privilegeTypeId) {
                        stateVO.setDesc("本月福利已领取");
                    }
                } else if (2 == isRecieve) {
                    stateVO.setType(BenefitStateEnum.EXPIRED);
                    if (4 == privilegeTypeId) {
                        stateVO.setDesc("暂不能领取");
                    }
                } else if (-1 == isRecieve) {
                    stateVO.setType(BenefitStateEnum.INVALID);
                    if (1 == privilegeTypeId) {
                        stateVO.setDesc("暂不能领取");
                    }
                }
                break;
            default:
                stateVO.setType(BenefitStateEnum.INVALID);
        }
        return stateVO;
    }
}
