package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.Type;

/**
 * 收藏扩展类型
 * 
 * @author Paul-xiong
 *
 */
public enum FavoriteExtType implements Type{
	PRODUCT(1, "商品"),
	ARTICLE(2, "文章"),
	;
	
	private final int id;
	private final String name;

	FavoriteExtType(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}
	
}
