package com.thebeastshop.support.enums.Customize;

import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 支持类型(0:小写字母 1:大写字母 2:数字 3:表情） Created by GFL on 2017/5/15.
 */
public enum LimitType {

    LOWER("0", "小写字母", "a-z"),
    UPPER("1", "大写字母", "A-Z"),
    NUMBER("2", "数字", "0-9"),
    HEART_SYMBOL("3", "爱心表情", "(\\[\\[love\\]\\])*","[[love]]"),
    POINT_SYMBOL("4", "英文点字符", ".","."),
    SMILE_SYMBOL("5", "笑脸表情", "(\\[\\[smile\\]\\])*","[[smile]]"),
    ARROW_HEART_SYMBOL("6", "一箭穿心表情", "(\\[\\[arrowheart\\]\\])*","[[arrowheart]]"),
    POINT_MIDDLE_SYMBOL("7", "英文中间点字符", "•","•"),
    LB_PHONE_SYMBOL("8", "手机", "(\\[\\[lbphone\\]\\])*","[[lbphone]]"),
    LB_BULB_SYMBOL("9", "灯泡", "(\\[\\[lbbulb\\]\\])*","[[lbbulb]]"),
    LB_AIRPLANE_SYMBOL("10", "飞机", "(\\[\\[lbairplane\\]\\])*","[[lbairplane]]"),
    LB_SUNGLASSES_SYMBOL("11", "墨镜", "(\\[\\[lbsunglasses\\]\\])*","[[lbsunglasses]]"),
    LB_FLASH_SYMBOL("12", "闪电", "(\\[\\[lbflash\\]\\])*","[[lbflash]]"),
    LB_STAR_SYMBOL("13", "五角星", "(\\[\\[lbstar\\]\\])*","[[lbstar]]"),
    LB_BICYCLE_SYMBOL("14", "自行车", "(\\[\\[lbbicycle\\]\\])*","[[lbbicycle]]"),
    LB_BOY_SYMBOL("15", "男孩","(\\[\\[lbboy\\]\\])*","[[lbboy]]"),
    LB_GIRL_SYMBOL("16", "女孩","(\\[\\[lbgirl\\]\\])*","[[lbgirl]]"),
    LB_OK_SYMBOL("17", "ok","(\\[\\[lbok\\]\\])*","[[lbok]]"),
    BROMEL_SYMBOL("18", "鳳梨","(\\[\\[bromel\\]\\])*","[[bromel]]"),

    // 十二星座
    ARIES_SYMBOL("21","白羊座","(\\[\\[aries\\]\\])*","[[aries]]"),
    TAURUS_SYMBOL("22","金牛座","(\\[\\[taurus\\]\\])*","[[taurus]]"),
    GEMINI_SYMBOL("23","双子座","(\\[\\[gemini\\]\\])*","[[gemini]]"),
    CANCER_SYMBOL("24","巨蟹座","(\\[\\[cancer\\]\\])*","[[cancer]]"),

    LEO_SYMBOL("25","狮子座","(\\[\\[leo\\]\\])*","[[leo]]"),
    VIRGO_SYMBOL("26","处女座","(\\[\\[virgo\\]\\])*","[[virgo]]"),
    LIBRA_SYMBOL("27","天秤座","(\\[\\[libra\\]\\])*","[[libra]]"),
    SCORPIO_SYMBOL("28","天蝎座","(\\[\\[scorpio\\]\\])*","[[scorpio]]"),

    SAGITTARIUS_SYMBOL("29","射手座","(\\[\\[sagittarius\\]\\])*","[[sagittarius]]"),
    CAPRICORN_SYMBOL("30","摩蝎座","(\\[\\[capricorn\\]\\])*","[[capricorn]]"),
    AQUARIUS_SYMBOL("31","水瓶座","(\\[\\[aquarius\\]\\])*","[[aquarius]]"),
    PISCES_SYMBOL("32","双鱼座","(\\[\\[pisces\\]\\])*","[[pisces]]"),

    ;

    private String code;
    private String value;
    private String regEx;
    private String symbol;

    private LimitType(String code, String value, String regEx) {
        this.code = code;
        this.value = value;
        this.regEx = regEx;
    }

    private LimitType(String code, String value, String regEx,String symbol) {
        this.code = code;
        this.value = value;
        this.regEx = regEx;
        this.symbol = symbol;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    public String getRegEx() {
        return regEx;
    }


    private static List<LimitType> basicsLimitTypes = Lists.newArrayList(LOWER,UPPER,NUMBER,POINT_SYMBOL,POINT_MIDDLE_SYMBOL);

    /**
     * 根据Code获取枚举
     *
     * @param code
     * @return
     */
    public static LimitType getLimitTypeByCode(String code) {
        for (LimitType value : LimitType.values()) {
            if (StringUtils.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }

    /**
     * 根据Code获取枚举
     *
     * @param codes
     * @return
     */
    public static List<LimitType> getLimitTypeByCodes(List<String> codes) {
        if (null == codes) {
            return null;
        }
        List<LimitType> limitTypes = Lists.newArrayList();
        for (String code : codes) {
            LimitType limitType = getLimitTypeByCode(code);
            if (null != limitType) {
                limitTypes.add(limitType);
            }
        }
        return limitTypes;
    }

    public static String getRegEx(List<LimitType> limitTypes) {
        StringBuffer regEx = new StringBuffer();
        // 基础字符正则组合
        StringBuffer regEx1 = new StringBuffer();
        for (LimitType basicsLimitType : basicsLimitTypes) {
            if(limitTypes.contains(basicsLimitType)){
                regEx1.append(basicsLimitType.getRegEx());
            }
        }

        if (StringUtils.isNotEmpty(regEx1)) {
            regEx1.insert(0, "[");
            regEx1.append("]*");
        }
        regEx.append("^(");
        regEx.append(regEx1);
        // 自定义标识符，正则组合
        for (LimitType limitType : limitTypes) {
            if(basicsLimitTypes.contains(limitType)){
                continue;
            }
            regEx.append(limitType.getRegEx());
        }
        regEx.append(")*$");
        return regEx.toString();
    }


    public static Integer getSymbolStrLength(String sourceStr, List<LimitType> limitTypes) {
        if(CollectionUtils.isNotEmpty(limitTypes)){
            for (LimitType limitType : limitTypes) {
                if(StringUtils.isNoneBlank(limitType.symbol)){
                    sourceStr = sourceStr.replace(limitType.symbol,"-");
                }
            }
        }
        return sourceStr.length();
    }

}
