package com.thebeastshop.support.coll;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;

/**
 * 将一个不知道其元素是什么类型的数组，适配成一个List。
 *
 * @author Liang Wenjian
 */
public class WhateverArrayAdaptList extends AbstractList<Object> implements List<Object> {

    private final Object arr;

    public WhateverArrayAdaptList(final Object arr) {
        final Class<?> aClass = arr.getClass();
        if(!aClass.isArray()) {
            throw new IllegalArgumentException("参数并非数组");
        }
        this.arr = arr;
    }

    @Override
    public Object get(final int index) {
        return Array.get(arr, index);
    }

    @Override
    public int size() {
        return Array.getLength(arr);
    }

    @SuppressWarnings("unchecked")
    public static <T> List<T> of(final Object arr) {
        return (List<T>) new WhateverArrayAdaptList(arr);
    }
}
