/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.enums;

import com.google.common.collect.Lists;
import com.thebeastshop.support.vo.member.LevelPointVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public enum PointLevel {
    NORMAL(-1, "\u6ce8\u518c\u7528\u6237", BigDecimal.ZERO),
    VIP(0, "\u677e\u9f20\u4f1a\u5458", BigDecimal.ONE),
    VIP2(1, "\u5c0f\u732b\u4f1a\u5458", new BigDecimal("5000")),
    VIP3(2, "\u8001\u864e\u4f1a\u5458", new BigDecimal("10000")),
    VIP4(3, "\u5927\u8c61\u4f1a\u5458", new BigDecimal("50000"));

    private int level;
    private String name;
    private BigDecimal minPoint;

    private PointLevel(int level, String name, BigDecimal minPoint) {
        this.level = level;
        this.name = name;
        this.minPoint = minPoint;
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getMinPoint() {
        return this.minPoint;
    }

    public static LevelPointVO getLevelPointByLevel(int level) {
        for (PointLevel value : PointLevel.values()) {
            if (value.getLevel() != level) continue;
            LevelPointVO levelPointVO = new LevelPointVO();
            levelPointVO.setLevel(value.getLevel());
            levelPointVO.setName(value.getName());
            levelPointVO.setMinPoint(value.getMinPoint());
            return levelPointVO;
        }
        return null;
    }

    public static List<LevelPointVO> getAllLevelPoint() {
        ArrayList list = Lists.newArrayList();
        for (PointLevel value : PointLevel.values()) {
            LevelPointVO levelPointVO = new LevelPointVO();
            levelPointVO.setLevel(value.getLevel());
            levelPointVO.setName(value.getName());
            levelPointVO.setMinPoint(value.getMinPoint());
            list.add(levelPointVO);
        }
        return list;
    }
}

