package com.thebeastshop.support.vo.search;

import java.util.List;

/**
 * @ClassName: IposSearchCond
 * @Description: ipos搜索条件
 * @author: xiang.gao
 * @date: 2021-10-29 11:14
 */
public class IposSearchCond {

    /**
     * 类目ID
     */
    private String categoryId;

    /**
     * 是否现货
     */
    private Boolean isSpot = false;

    /**
     * 是否组合
     */
    private Boolean isCombined = false;

    /**
     * 是否海淘
     */
    private Boolean isOversea = false;

    /**
     * 是否新人专享
     */
    private Boolean isNewcomer = false;

    /**
     * 是否生日礼商品
     */
    private Boolean isBdayGift = false;

    /**
     * 搜索关键字
     */
    private String keyword;

    /**
     * 商品CODE
     */
    private List<String> prodCodes;

    /**
     * offset = 0， 对应于从第 1 条
     */
    private int offset = 0;

    /**
     * 默认一共取 20 条
     */
    private int limit = 20;

    public String getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public Boolean getIsSpot() {
        return isSpot;
    }

    public void setIsSpot(Boolean isSpot) {
        isSpot = isSpot;
    }

    public Boolean getIsCombined() {
        return isCombined;
    }

    public void setIsCombined(Boolean isCombined) {
        isCombined = isCombined;
    }

    public Boolean getIsOversea() {
        return isOversea;
    }

    public void setIsOversea(Boolean isOversea) {
        isOversea = isOversea;
    }

    public Boolean getIsNewcomer() {
        return isNewcomer;
    }

    public void setIsNewcomer(Boolean isNewcomer) {
        isNewcomer = isNewcomer;
    }

    public Boolean getIsBdayGift() {
        return isBdayGift;
    }

    public void setIsBdayGift(Boolean isBdayGift) {
        isBdayGift = isBdayGift;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<String> getProdCodes() {
        return prodCodes;
    }

    public void setProdCodes(List<String> prodCodes) {
        this.prodCodes = prodCodes;
    }

    public int getOffset() {
        return offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public String toString() {
        return "IposSearchCond{" +
                "categoryId='" + categoryId + '\'' +
                ", isSpot=" + isSpot +
                ", isCombined=" + isCombined +
                ", isOversea=" + isOversea +
                ", isNewcomer=" + isNewcomer +
                ", isBdayGift=" + isBdayGift +
                ", keyword='" + keyword + '\'' +
                ", prodCodes=" + prodCodes +
                ", offset=" + offset +
                ", limit=" + limit +
                '}';
    }
}
