package com.thebeastshop.support.vo.customize;

import com.thebeastshop.support.enums.Customize.CustomizeMode;

import java.io.Serializable;
import java.util.List;

/**
 * 定制维度
 * Created by feilong.gao on 2016/12/12.
 */
public class CustomDimension implements Serializable{


    private static final long serialVersionUID = -7232604886622003044L;

    /**
     * 定制元素唯一编码
     * mode 为：TEXT_COLOR|TEXT_INPUT 时 code规则为：imgId_positionIndex_[color|word]
     */
    private String code;

    /**
     * 图片id
     */
    private Integer imageId;
    /**
     * 定制区域标志
     */
    private Integer positionIndex;
    /**
     * 定制区域名字
     */
    private String positionName;

    /**
     * 定制元素名字
     */
    private String name;
    /**
     * 定制元素类型:<SELECT|INPUT>
     */
    private String type;
    /**
     * 定制元素Icon图片
     */
    private String icon;
    /**
     * 定制属性选项列表
     */
    private List<CustomChoice> choices;

    /**
     * type= input时输入框显示信息
     */
    private String placeholder;
    /**
     * 输入限制
     */
    private InputLimit limit;

    /**
     * 补充说明
     */
    private String note;

    /**
     * 定制模式
     */
    private CustomizeMode mode = CustomizeMode.NORMAL;

    /**
     * 是否隐藏
     */
    private Boolean hidden = Boolean.FALSE;


    public Integer getImageId() {
        return imageId;
    }

    public void setImageId(Integer imageId) {
        this.imageId = imageId;
    }

    public Integer getPositionIndex() {
        return positionIndex;
    }

    public void setPositionIndex(Integer positionIndex) {
        this.positionIndex = positionIndex;
    }

    public String getPositionName() {
        return positionName;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<CustomChoice> getChoices() {
        return choices;
    }

    public void setChoices(List<CustomChoice> choices) {
        this.choices = choices;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public InputLimit getLimit() {
        return limit;
    }

    public void setLimit(InputLimit limit) {
        this.limit = limit;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public CustomizeMode getMode() {
        return mode;
    }

    public void setMode(CustomizeMode mode) {
        this.mode = mode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("CustomDimension{");
        sb.append("code='").append(code).append('\'');
        sb.append(", imageId=").append(imageId);
        sb.append(", positionIndex=").append(positionIndex);
        sb.append(", positionName='").append(positionName).append('\'');
        sb.append(", name='").append(name).append('\'');
        sb.append(", type='").append(type).append('\'');
        sb.append(", icon='").append(icon).append('\'');
        sb.append(", choices=").append(choices);
        sb.append(", placeholder='").append(placeholder).append('\'');
        sb.append(", limit=").append(limit);
        sb.append(", note='").append(note).append('\'');
        sb.append(", mode=").append(mode);
        sb.append(", hidden=").append(hidden);
        sb.append('}');
        return sb.toString();
    }
}
