package com.thebeastshop.support.mark;

import com.google.common.collect.Lists;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * 有“排序”字段的事物的抽象接口。
 *
 * @author Liang Wenjian
 */
public interface HasRanking extends RankingCons {
	String PROPERTY_NAME = RankingCons.PROPERTY_NAME;

	double getRanking();

	/**
	 * 提供给HasRanking对象的工具类。
	 */
	class RankingUtil implements RankingCons {

		public static <T extends HasRanking> List<T> rankingAsc(final Collection<T> source) {
			return sort(source, RANKING_ASC);
		}

		public static <T extends HasRanking> List<T> rankingDesc(final Collection<T> source) {
			return sort(source, RANKING_DESC);
		}

		private static <T extends HasRanking> List<T> sort(final Collection<T> source,
				final Comparator<HasRanking> comparator) {
			final List<T> list;
			if (source instanceof List) {
				list = (List<T>) source;
			} else {
				list = Lists.newArrayList(source);
			}
			Collections.sort(list, comparator);
			return list;
		}

		private RankingUtil() {
			super();
		}
	}
}

interface RankingCons {

	String PROPERTY_NAME = "ranking";

	Comparator<HasRanking> RANKING_ASC = new Comparator<HasRanking>() {
		@Override
		public int compare(HasRanking o1, HasRanking o2) {
			return Double.compare(o1.getRanking(), o2.getRanking());
		};
	};

	Comparator<HasRanking> RANKING_DESC = new Comparator<HasRanking>() {
		@Override
		public int compare(HasRanking o1, HasRanking o2) {
			return Double.compare(o2.getRanking(), o1.getRanking());
		};
	};

}