package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.Type;

/**
 * 运费计算类型
 * 
 * @author daqing
 * @date 2020-07-24
 *
 */
public enum DeliverCalType implements Type {
	Fixed(0, "固定运费"), ByDistance(1, "按距离");

	private final Integer id;
	private final String name;

	DeliverCalType(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

	public static DeliverCalType getById(Integer id){
		for (DeliverCalType expressFeeType : values()){
			if (expressFeeType.getId().equals(id)){
				return expressFeeType;
			}
		}
		return null;
	}
}
