package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.flowerMonth.FlowerMonthDistType;
import com.thebeastshop.support.vo.product.SimpleProductVO.DiscVO;
import com.thebeastshop.support.vo.product.SimpleProductVO.PriceForecastVO;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;

/**
 * 商品详细
 * 
 * @author Paul-xiong
 *
 */
public class ProductVO implements Serializable {

	private static final long serialVersionUID = 5874380718123289421L;
	/**
	 * 到手价标签
	 */
	private StrikePriceTagVO strikePriceTag;

	/**
	 * 定金信息
	 */
	private DownPaymentVO downPayment;

	private GrouponVO groupon;// 团购信息

	/**
	 * 是否旧版本数据
	 */
	private Boolean legacyDetails = false;

	private SimpleProductVO raw = new SimpleProductVO();
	/**
	 * 徽章
	 */
	private List<ProductBadgeVO> badges = new ArrayList<ProductBadgeVO>();
	/**
	 * 价格（代替原有discount）
	 */
	private List<PriceTagVO> priceTags = new ArrayList<PriceTagVO>();

	/**
	 * 是否需要验证地址
	 */
	private boolean needVerifyAddress = false;
	/**
	 * 提示
	 */
	private List<ProductTipVO> tips = new ArrayList<ProductTipVO>();
	/**
	 * 规格
	 */
	private ProductVariantVO variant = new ProductVariantVO();
	/**
	 * 分享
	 */
	private ProductShareVO share = new ProductShareVO();
	/**
	 * 是否收藏
	 */
	private Boolean favorited = false;
	/**
	 * 是否大家具
	 */
	private Boolean furniture = false;

	/**
	 * 月送
	 */
	private Boolean monthSend = false;

	/**
	 * 月送配送类型
	 */
	private FlowerMonthDistType monthSendDistType = FlowerMonthDistType.EXPRESS;

	/**
	 * 该商品页是否使用 HTML 代替。定制商品为true
	 */
	private Boolean useHTML = false;

	/**
	 * 商品页 HTML 跳转链接
	 */
	private String htmlLink ;
	/**
	 * 是否为预售商品，若不是预售，则为 null
	 */
	private PreSellVO presell;

	/**
	 * 线上专享商品
	 */
	private Boolean onLineOnly = false;
	
	/**
	 * 是否有可选 优惠卷
	 */
	private Boolean isCoupon = false;
	
	private String productId;

	/**
	 * 定制卡片
	 */
	private Boolean canCustomCard;

	public Boolean getFurniture() {
		return furniture;
	}

	public void setFurniture(Boolean furniture) {
		this.furniture = furniture;
	}

	public PrevueVO getPrevue() {
		return prevue;
	}

	public void setPrevue(PrevueVO prevue) {
		this.prevue = prevue;
	}

	public Boolean getLegacyDetails() {
		return legacyDetails;
	}

	/**
	 * 是否为预告商品
	 */
	private PrevueVO prevue;

	/**
	 * 到货提醒
	 */
	private ArrivalReminderVO arrival = new ArrivalReminderVO();

	private List<VideoVO> videos;
	/**
	 * 水印图标
	 */
	private List<String> waterMarkImage;

	private PriceForecastVO priceForecast;

	private Boolean buyable;

	public GrouponVO getGroupon() {
		return groupon;
	}

	public void setGroupon(GrouponVO groupon) {
		this.groupon = groupon;
	}

	public List<VideoVO> getVideos() {
		return videos;
	}

	public void setVideos(List<VideoVO> videos) {
		this.videos = videos;
	}

	public Boolean getBuyable() {
		return buyable;
	}

	public void setBuyable(Boolean buyable) {
		this.buyable = buyable;
	}

	public PriceForecastVO getPriceForecast() {
		return priceForecast;
	}

	public void setPriceForecast(PriceForecastVO priceForecast) {
		this.priceForecast = priceForecast;
	}

	public ProductVO() {
		super();
	}

	public ProductVO(SimpleProductVO raw) {
		this.raw = raw;
	}

	public Boolean getForetell() {
		return raw.getForetell();
	}

	public void setForetell(Boolean foretell) {
		raw.setForetell(foretell);
	}

	public Boolean getIsOversea() {
		return raw.getIsOversea();
	}

	public void setIsOversea(Boolean isOversea) {
		raw.setIsOversea(isOversea);
	}

	public Boolean getCustomizable() {
		return raw.getCustomizable();
	}

	public void setCustomizable(Boolean customizable) {
		raw.setCustomizable(customizable);
	}

	public boolean getCombination() {
		return raw.getCombination();
	}

	public void setCombination(boolean combination) {
		raw.setCombination(combination);
	}

	public DiscVO getDiscount() {
		return raw.getDiscount();
	}

	public void setDiscount(DiscVO discount) {
		raw.setDiscount(discount);
	}

	public String getFeatureImage() {
		return raw.getFeatureImage();
	}

	public void setFeatureImage(String featureImage) {
		raw.setFeatureImage(featureImage);
	}


	public String getSpecialImage() {
		return raw.getSpecialImage();
	}

	public void setSpecialImage(String specialImage) {
		raw.setSpecialImage(specialImage);
	}

	public String getSpecialDesc() {
		return raw.getSpecialDesc();
	}

	public void setSpecialDesc(String specialDesc) {
		raw.setSpecialDesc(specialDesc);
	}

	public String getId() {
		return raw.getId();
	}

	public BrandVO getBrand() {
		return raw.getBrand();
	}

	public String getName() {
		return raw.getName();
	}

	public String getSummary() {
		return raw.getSummary();
	}

	public BigDecimal getRawPrice() {
		return raw.getRawPrice();
	}

	public BigDecimal getPrice() {
		return raw.getPrice();
	}

	public Boolean getSoldOut() {
		return raw.getSoldOut();
	}

	public Boolean getInvisible() {
		return raw.getInvisible();
	}

	public void setInvisible(Boolean invisible) {
		raw.setInvisible(invisible);
	}

	public Boolean getOffShelf() {
		return raw.getOffShelf();
	}

	public void setOffShelf(Boolean offShelf) {
		raw.setOffShelf(offShelf);
	}

	public List<Label> getLabels() {
		return raw.getLabels();
	}

	public void setLabels(List<Label> labels) {
		raw.setLabels(labels);
	}

	public List<ProductBadgeVO> getBadges() {
		return badges;
	}

	public List<ProductTipVO> getTips() {
		return tips;
	}

	public ProductVariantVO getVariant() {
		return variant;
	}

	public void setId(String id) {
		raw.setId(id);
	}

	public List<String> getImages() {
		return raw.getImages();
	}

	public void setImages(List<String> images) {
		raw.setImages(images);
	}

	public void setBrand(BrandVO brand) {
		raw.setBrand(brand);
	}

	public void setName(String name) {
		raw.setName(name);
	}

	public void setSummary(String summary) {
		raw.setSummary(summary);
	}

	public void setRawPrice(BigDecimal rawPrice) {
		raw.setRawPrice(rawPrice);
	}

	public void setPrice(BigDecimal price) {
		raw.setPrice(price);
	}

	public void setPointPrice(BigDecimal pointPrice){
		raw.setPointPrice(pointPrice);
	}
	public BigDecimal getPointPrice(){
		return raw.getPointPrice();
	}


	public Boolean getPointDeduction() {
		return raw.getPointDeduction();
	}

	public void setPointDeduction(Boolean pointDeduction) {
		raw.setPointDeduction(pointDeduction);
	}

	public Integer getPoint() {
		return raw.getPoint();
	}

	public void setPoint(Integer point) {
		raw.setPoint(point);
	}

	public void setSoldOut(Boolean soldOut) {
		raw.setSoldOut(soldOut);
	}

	public Boolean getNewcomerTag(){
		return raw.getNewcomerTag();
	}

	public void setNewcomerTag(Boolean newcomerTag){
		raw.setNewcomerTag(newcomerTag);
	}

	public Boolean getFavorited() {
		return favorited;
	}

	public ProductShareVO getShare() {
		return share;
	}

	public void setShare(ProductShareVO share) {
		this.share = share;
	}

	public void setFavorited(Boolean favorited) {
		this.favorited = favorited;
	}

	public boolean isNeedVerifyAddress() {
		return needVerifyAddress;
	}

	public void setNeedVerifyAddress(boolean needVerifyAddress) {
		this.needVerifyAddress = needVerifyAddress;
	}

	public void setBadges(List<ProductBadgeVO> badges) {
		this.badges = badges;
	}

	public void setTips(List<ProductTipVO> tips) {
		this.tips = tips;
	}

	public void setVariant(ProductVariantVO variant) {
		this.variant = variant;
	}

	public List<String> getWaterMarkImage() {
		return waterMarkImage;
	}

	public void setWaterMarkImage(List<String> waterMarkImage) {
		this.waterMarkImage = waterMarkImage;
	}

	public PreSellVO getPresell() {
		return presell;
	}

	public void setPresell(PreSellVO presell) {
		this.presell = presell;
	}

	public Boolean getUseHTML() {
		return useHTML;
	}

	public void setUseHTML(Boolean useHTML) {
		this.useHTML = useHTML;
	}

	public String getHtmlLink() {
		return htmlLink;
	}

	public void setHtmlLink(String htmlLink) {
		this.htmlLink = htmlLink;
	}

	public Boolean getMonthSend() {
		return monthSend;
	}

	public void setMonthSend(Boolean monthSend) {
		this.monthSend = monthSend;
	}

	public FlowerMonthDistType getMonthSendDistType() {
		return monthSendDistType;
	}

	public void setMonthSendDistType(FlowerMonthDistType monthSendDistType) {
		this.monthSendDistType = monthSendDistType;
	}

	public List<PriceTagVO> getPriceTags() {
		return priceTags;
	}

	public void setPriceTags(List<PriceTagVO> priceTags) {
		this.priceTags = priceTags;
	}

	public Boolean isLegacyDetails() {
		return legacyDetails;
	}

	public void setLegacyDetails(Boolean legacyDetails) {
		this.legacyDetails = legacyDetails;
	}

	public SimpleProductVO getRaw() {
		return raw;
	}

	public void setRaw(SimpleProductVO raw) {
		this.raw = raw;
	}

	public DownPaymentVO getDownPayment() {
		return downPayment;
	}

	public void setDownPayment(DownPaymentVO downPayment) {
		this.downPayment = downPayment;
	}

	public StrikePriceTagVO getStrikePriceTag() {
		return strikePriceTag;
	}

	public void setStrikePriceTag(StrikePriceTagVO strikePriceTag) {
		this.strikePriceTag = strikePriceTag;
	}

	public Boolean getOnLineOnly() {
		return onLineOnly;
	}

	public void setOnLineOnly(Boolean onLineOnly) {
		this.onLineOnly = onLineOnly;
	}

	public ArrivalReminderVO getArrival() {
		return arrival;
	}

	public void setArrival(ArrivalReminderVO arrival) {
		this.arrival = arrival;
	}
	
	public Boolean getIsCoupon() {
		return isCoupon;
	}

	public void setIsCoupon(Boolean isCoupon) {
		this.isCoupon = isCoupon;
	}

	
	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public Boolean getCanCustomCard() {
		return canCustomCard;
	}

	public void setCanCustomCard(Boolean canCustomCard) {
		this.canCustomCard = canCustomCard;
	}

	@Override
	public String toString() {
		final StringBuffer sb = new StringBuffer("ProductVO{");
		sb.append("raw=").append(raw);
		sb.append(", badges=").append(badges);
		sb.append(", needVerifyAddress=").append(needVerifyAddress);
		sb.append(", tips=").append(tips);
		sb.append(", variant=").append(variant);
		sb.append(", share=").append(share);
		sb.append(", favorited=").append(favorited);
		sb.append(", useHTML=").append(useHTML);
		sb.append(", htmlLink=").append(htmlLink);
		sb.append(", presell=").append(presell);
		sb.append(", waterMarkImage='").append(waterMarkImage).append('\'');
		sb.append(", priceForecast=").append(priceForecast);
		sb.append(", buyable=").append(buyable);
		sb.append(", prevue=").append(prevue);
		sb.append(", arrival=").append(arrival);
		sb.append(", videos=").append(videos);
		sb.append(", priceTags=").append(priceTags);
		sb.append(", legacyDetails=").append(legacyDetails);
		sb.append(", furniture=").append(furniture);
		sb.append(", groupon=").append(groupon);
		sb.append(", downPayment=").append(downPayment);
		sb.append(", onLineOnly=").append(onLineOnly);
		sb.append('}');
		return sb.toString();
	}
}
