package com.thebeastshop.support.vo.price;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description 价格明细
 * @Author Xiang.Gao
 * @Create In 2019/10/22
 */
public class PriceInfoVO {

    /**
     * 折扣价
     */
    private BigDecimal discountPrice;

    /**
     * 价格步骤
     */
    private List<PriceStepVO> priceSteps = Lists.newArrayList();

    /**
     * 描述
     */
    private String desc;

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public List<PriceStepVO> getPriceSteps() {
        return priceSteps;
    }

    public void setPriceSteps(List<PriceStepVO> priceSteps) {
        this.priceSteps = priceSteps;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 价格步骤
     */
    public static class PriceStepVO {

        /**
         * 名称
         */
        private String name;

        /**
         * 价格变化
         */
        private BigDecimal priceChange;

        /**
         * 字体颜色
         */
        private String fontColor;

        public PriceStepVO() {
            super();
        }

        public PriceStepVO(String name, BigDecimal priceChange, String fontColor) {
            this.name = name;
            this.priceChange = priceChange;
            this.fontColor = fontColor;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public BigDecimal getPriceChange() {
            return priceChange;
        }

        public void setPriceChange(BigDecimal priceChange) {
            this.priceChange = priceChange;
        }

        public String getFontColor() {
            return fontColor;
        }

        public void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
