package com.thebeastshop.support.vo.order;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.List;

/**
 * @ClassName: OrderCustomCardVO
 * @Description: 定制卡片
 * @author: Xiang.Gao
 * @date: 2020/11/10 15:26
 */
public class OrderCustomCardVO {

    public interface CardStyle {
        //BASE-普通样式 LOVER-情人节样式;
        String BASE = "BASE";
        String LOVER = "LOVER";
    }

    /**
     * 是否可编辑
     */
    private Boolean canCustom;

    /**
     * 是否已定制
     */
    private Boolean customized;


    /**
     * 定制卡片类型：BASE-普通样式 LOVER-情人节样式
     */
    private String cardStyle = CardStyle.BASE;

    /**
     * 总数
     */
    private Integer total;

    /**
     * 空白卡片数
     */
    private Integer blankNum;

    /**
     * 代写卡片数
     */
    private Integer writeNum;

    /**
     * 卡片集合
     */
    private List<OrderCard> cards;

    public Boolean getCanCustom() {
        return canCustom;
    }

    public void setCanCustom(Boolean canCustom) {
        this.canCustom = canCustom;
    }

    public Boolean getCustomized() {
        return customized;
    }

    public void setCustomized(Boolean customized) {
        this.customized = customized;
    }

    public String getCardStyle() {
        return cardStyle;
    }

    public void setCardStyle(String cardStyle) {
        this.cardStyle = cardStyle;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getBlankNum() {
        return blankNum;
    }

    public void setBlankNum(Integer blankNum) {
        this.blankNum = blankNum;
    }

    public Integer getWriteNum() {
        return writeNum;
    }

    public void setWriteNum(Integer writeNum) {
        this.writeNum = writeNum;
    }

    public List<OrderCard> getCards() {
        return cards;
    }

    public void setCards(List<OrderCard> cards) {
        this.cards = cards;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("canCustom", canCustom)
                .append("customized", customized)
                .append("cardStyle", cardStyle)
                .append("total", total)
                .append("blankNum", blankNum)
                .append("writeNum", writeNum)
                .append("cards", cards)
                .toString();
    }
}
