package com.thebeastshop.support.vo.exchange;

import com.thebeastshop.support.enums.exchange.ExchangeGoodsClassify;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author feilong.gao
 * @Date 2018/5/23 15:14.
 * @Description
 */
public class ExchangeGoods implements Serializable {

    private static final long serialVersionUID = -9206619830887457411L;

    private Integer Id;
    private String code;
    private Boolean soldOut = Boolean.FALSE;
    private List<Integer> levelIds;
    private List<String> accessWays;
    private String mode;
    private Integer point;
    private BigDecimal exchangePrice;
    private Integer total;
    protected ExchangeGoodsClassify classify = ExchangeGoodsClassify.UNKNOWN;
    private Boolean online = Boolean.FALSE;
    private Boolean secKill = Boolean.FALSE;
    private Boolean needVerify=Boolean.TRUE;     //兑换需要验证
    private String tips;             // 提示信息

    public Integer getId() {
        return Id;
    }

    public void setId(Integer id) {
        Id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getSoldOut() {
        return soldOut;
    }

    public void setSoldOut(Boolean soldOut) {
        this.soldOut = soldOut;
    }

    public List<Integer> getLevelIds() {
        return levelIds;
    }

    public void setLevelIds(List<Integer> levelIds) {
        this.levelIds = levelIds;
    }

    public List<String> getAccessWays() {
        return accessWays;
    }

    public void setAccessWays(List<String> accessWays) {
        this.accessWays = accessWays;
    }

    public Integer getPoint() {
        return point;
    }

    public void setPoint(Integer point) {
        this.point = point;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public ExchangeGoodsClassify getClassify() {
        return classify;
    }

    public void setClassify(ExchangeGoodsClassify classify) {
        this.classify = classify;
    }

    public Boolean getOnline() {
        return online;
    }

    public void setOnline(Boolean online) {
        this.online = online;
    }

    public Boolean getSecKill() {
        return secKill;
    }

    public void setSecKill(Boolean secKill) {
        this.secKill = secKill;
    }

    public String getTips() {
        return tips;
    }

    public void setTips(String tips) {
        this.tips = tips;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public BigDecimal getExchangePrice() {
        return exchangePrice;
    }

    public void setExchangePrice(BigDecimal exchangePrice) {
        this.exchangePrice = exchangePrice;
    }

    public Boolean getNeedVerify() {
        return needVerify;
    }

    public void setNeedVerify(Boolean needVerify) {
        this.needVerify = needVerify;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("ExchangeGoods{");
        sb.append("Id=").append(Id);
        sb.append(", code='").append(code).append('\'');
        sb.append(", soldOut=").append(soldOut);
        sb.append(", levelIds=").append(levelIds);
        sb.append(", mode=").append(mode);
        sb.append(", point=").append(point);
        sb.append(", exchangePrice=").append(exchangePrice);
        sb.append(", total=").append(total);
        sb.append(", classify=").append(classify);
        sb.append(", online=").append(online);
        sb.append(", secKill=").append(secKill);
        sb.append(", tips='").append(tips).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
