package com.thebeastshop.support.page;

public class Pagination {
	private static final int MAX_LIMIT = 1000; // 单页最大
	private Integer offset = 0;
	private Integer limit = 15;
	private Integer total = 0;
	private Sort sort = new Sort();

	public Pagination() {
	}

	public Pagination(Integer offset, Integer limit) {
		this.setOffset(offset);
		this.setLimit(limit);
	}

	public Pagination(Integer offset, Integer limit, Sort sort) {
		this(offset, limit);
		if (sort != null)
			this.sort = sort;
	}

	public Pagination(Pagination pagination) {
		if (pagination == null) {
			throw new NullPointerException("pagination is null");
		}
		this.offset = pagination.offset;
		this.limit = pagination.limit;
		this.total = pagination.total;
		if (pagination.getSortField() != null) {
			this.setSortField(pagination.getSortField());
		}
		if (pagination.getSortOrder() != null) {
			this.setSortOrder(pagination.getSortOrder());
		}
	}

	public Integer getOffset() {
		return offset;
	}

	public void setOffset(Integer offset) {
		if (offset != null && offset >= 0) {
			this.offset = offset;
		}
	}

	public Integer getLimit() {
		return limit;
	}

	public void setLimit(Integer limit) {
		if (limit != null && limit > 0) {
			if (limit > MAX_LIMIT) {
				limit = MAX_LIMIT;
			}
			this.limit = limit;
		}
	}

	public Integer getTotal() {
		return total;
	}

	public void setTotal(Integer total) {
		if (total != null) {
			this.total = total;
		}
	}

	public String getSortField() {
		return sort.getSortField();
	}

	public void setSortField(String sortField) {
		sort.setSortField(sortField);
	}

	public String getSortOrder() {
		return sort.getSortOrder();
	}

	public void setSortOrder(String sortOrder) {
		sort.setSortOrder(sortOrder);
	}

	public int hashCode() {
		return sort.hashCode();
	}

	public boolean equals(Object obj) {
		return sort.equals(obj);
	}

	@Override
	public String toString() {
		return "Pagination [offset=" + offset + ", limit=" + limit + ", total=" + total + ", sort=" + sort + "]";
	}
}
