package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.Type;

/**
 * 高捷订单状态 Created by jim.huang on 2016/12/13.
 */
public enum PackageDeclarationStateEnum implements Type {

	/* 仓库状态 */
	NOT_SEND_WARAHOUSE(1, "未下发仓库", 1, ""),
	SEND_WARAHOUSE(2, "已下发仓库", 1, ""), 
	NOT_OUT_WARAHOUSE(3, "未出库", 1, ""), 
	IDENTITY_REPREAT(4, "身份证重复", 1, ""),
	FINISH_WARAHOUSE_OPRATION(	5, "仓库完成操作", 1, "【已发货】海外转运中"),
	
	/* 订单状态 */
	ORDER_NOT_CONFIRM(6, "订单未确认", 2, ""), 
	ORDER_CANCEL(7, "订单已取消", 2, ""), 
	WAIT_DECLARATION(8, "带报关", 2, ""), 
	DECLARATION_CHECK(9, "报关审核中", 2, "【海关清关中】等待海关放行"), 
	DECLARATION_PASS(10, "报关通过", 2, "【清关成功】等待国内配送"),
	
	/* 支付宝报关状态,小于0表示处理异常回执 */
	ALIPAY_IN_DECLARATION(2, "电子口岸申报中", 3, ""), 
	ALIPAY_SEND_CUSTIOM_SUCCESS(3,"发送海关成功", 3, ""), 
	ALIPAY_SEND_CUSTOM_FAIL(4, "发送海关失败", 3, ""), 
	ALIPA_CUSTOM_CHARGEBACK(100, "海关退单", 3, ""), 
	ALIPAY_CUSTOM_CONCLUDE(399, "海关审结", 3, ""),
	
	/* 订单海关报关状态,小于0表示处理异常回执 */
	IN_DECLARATION(2, "订单新增申报成功", 4, ""), 
	SEND_CUSTIOM_SUCCESS(3, "发送海关成功", 4,""),
	SEND_CUSTOM_FAIL(4, "发送海关失败", 4, ""), 
	CUSTOM_CHARGEBACK(100,"海关退单", 4, ""),
	CUSTOM_IN_STORAGE(120, "海关入库", 4, "");

	public final int id;
	public final String name;
	public final int type;
	public final String content;

	PackageDeclarationStateEnum(int id, String name, int type, String content) {
		this.id = id;
		this.name = name;
		this.type = type;
		this.content = content;
	}

	@Override
	public Integer getId() {
		// TODO Auto-generated method stub
		return id;
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return name;
	}

	public int getType() {
		return type;
	}

	public String getContent() {
		return content;
	}

}
