package com.thebeastshop.support;

import java.io.Serializable;

/**
 * **type** `Enum.<none|article|shop|shop-story|list|product|category|oversea|categoryOversea|deeplink|brand|tag|group|new|customization-list|all|bu>`
 * **value** `String` 取值如下
 * none '' 不跳转
 * article articleId `beastapp://article/${articleId}`
 * shop shopId `beastapp://shop/${shopId}`
 * shop-story shopId `beastapp://entry?name=shop-story&shopId=${shopId}`
 * list 列表id  `beastapp://search?listId=${listId}`
 * category 多个分类id，英文逗号分隔（e.g. `'101,102,103'`）`beastapp://search?categoryId=101&categoryId=102&categoryId=103`
 * product 商品code `beastapp://product/${productId}`
 * oversea value为''，在link的query里加入'overseasOnly=true'  `beastapp://search?overseasOnly=true`
 * categoryOversea value为多个分类id，英文逗号分隔（e.g. `'101,102,103'`）`beastapp://search?overseasOnly=true&categoryId=101&categoryId=102&categoryId=103`
 * deeplink deeplink 直接跳deeplink
 * brand 多个品牌id，英文逗号分隔（e.g. `'101,102,103'`）`beastapp://search?brandId=101&brandId=102&brandId=103`
 * tag 多标签\(e.g. `'101,102,103'`\) `beastapp://search?labelId=101,102,103`
 * group 团购商品Code `beastapp://entry?name=group-purchase&productId=${productId}`
 * new 最新上架 `beastapp://search?new=1`
 * customization-list 定制列表 `beastapp://entry?name=customization-list`
 * all 全部商品 `beastapp://search`
 * bu buId-categoryIds `beastapp://search?buId=1&catgoryId=2,3,4` categoryIds可为空
 * program 小程序链接 直接跳转填写的链接
 * <p>
 * Author : feilong.gao
 * email : feilong.gao.thebeastshop.com
 * date : 2020/6/9
 */
public class Link implements Serializable {

    private static final long serialVersionUID = -5306523726211625304L;
    /**
     *
     */
    private String type;

    private String value;

    public Link() {
    }

    public Link(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "Link [type =" + type + ", value =" + value + "]";
    }
}
