/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.util;

import com.google.common.collect.Maps;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.mark.HasPrice;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.LoggerFactory;

public class PriceUtil {
    public static BigDecimal keepToCent(BigDecimal d) {
        return d.setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal keepToCent(HasPrice hasPrice) {
        return PriceUtil.keepToCent(hasPrice.getPrice());
    }

    public static BigDecimal multiPrice(BigDecimal price, int count) {
        return PriceUtil.keepToCent(price.multiply(BigDecimal.valueOf(count)));
    }

    public static BigDecimal sumPrice(Collection<? extends HasPrice> source) {
        BigDecimal rt = BigDecimal.ZERO;
        for (HasPrice hasPrice : source) {
            rt = rt.add(hasPrice.getPrice());
        }
        return PriceUtil.keepToCent(rt);
    }

    public static Map<HasPrice, BigDecimal> sharePrice(List<? extends HasPrice> source, BigDecimal price) {
        if (CollectionUtils.isNotEmpty(source)) {
            HashMap origin = Maps.newHashMap();
            for (HasPrice hasPrice : source) {
                origin.put(hasPrice, hasPrice.getPrice());
            }
            return PriceUtil.sharePrice(origin, price);
        }
        return null;
    }

    public static <T> Map<T, BigDecimal> sharePrice(Map<T, BigDecimal> source, BigDecimal price) {
        HashMap rt = Maps.newHashMap(source);
        BigDecimal allPrice = BigDecimal.ZERO;
        BigDecimal balancePrice = price;
        Set<T> keySet = source.keySet();
        if (CollectionUtils.isNotEmpty(keySet)) {
            for (T key : keySet) {
                if (key == null) {
                    LoggerFactory.getLogger(PriceUtil.class).error("\u8c01\u628anull\u653e\u8fdb\u6765\u4e86:" + source);
                    throw new UnknownException();
                }
                allPrice = allPrice.add(source.get(key));
            }
            Iterator<T> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                BigDecimal originPrice = source.get(t);
                if (iterator.hasNext()) {
                    BigDecimal sharedPrice = PriceUtil.keepToCent(originPrice.multiply(price).divide(allPrice, 10, RoundingMode.HALF_UP));
                    balancePrice = balancePrice.subtract(sharedPrice);
                    rt.put(t, sharedPrice);
                    continue;
                }
                rt.put(t, balancePrice);
            }
        }
        return rt;
    }

    public static Map<HasPrice, BigDecimal> shareDiscount(List<? extends HasPrice> source, BigDecimal discount) {
        if (CollectionUtils.isNotEmpty(source)) {
            HashMap origin = Maps.newHashMap();
            for (HasPrice hasPrice : source) {
                origin.put(hasPrice, hasPrice.getPrice());
            }
            return PriceUtil.shareDiscount(origin, discount);
        }
        return null;
    }

    public static <T> Map<T, BigDecimal> shareDiscount(Map<T, BigDecimal> source, BigDecimal dicount) {
        HashMap rt = Maps.newHashMap(source);
        BigDecimal allPrice = BigDecimal.ZERO;
        BigDecimal balancePrice = dicount;
        Set<T> keySet = source.keySet();
        if (CollectionUtils.isNotEmpty(keySet)) {
            for (T key : keySet) {
                if (key == null) {
                    LoggerFactory.getLogger(PriceUtil.class).error("\u8c01\u628anull\u653e\u8fdb\u6765\u4e86:" + source);
                    throw new UnknownException();
                }
                allPrice = allPrice.add(source.get(key));
            }
            Iterator<T> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                BigDecimal originPrice = source.get(t);
                if (iterator.hasNext()) {
                    BigDecimal sharedPrice = PriceUtil.keepToCent(originPrice.multiply(dicount).divide(allPrice, 10, RoundingMode.HALF_UP));
                    balancePrice = balancePrice.subtract(sharedPrice).compareTo(BigDecimal.ZERO) > 0 ? balancePrice.subtract(sharedPrice) : BigDecimal.ZERO;
                    BigDecimal price = originPrice.subtract(sharedPrice).compareTo(BigDecimal.ZERO) > 0 ? PriceUtil.keepToCent(originPrice.subtract(sharedPrice)) : BigDecimal.ZERO;
                    rt.put(t, price);
                    continue;
                }
                BigDecimal price = originPrice.subtract(balancePrice).compareTo(BigDecimal.ZERO) > 0 ? PriceUtil.keepToCent(originPrice.subtract(balancePrice)) : BigDecimal.ZERO;
                rt.put(t, price);
            }
        }
        return rt;
    }
}

