/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.mark;

import com.google.common.collect.Lists;
import com.thebeastshop.support.mark.RankingCons;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public interface HasRanking
extends RankingCons {
    public static final String PROPERTY_NAME = "ranking";

    public double getRanking();

    public static class RankingUtil
    implements RankingCons {
        public static <T extends HasRanking> List<T> rankingAsc(Collection<T> source) {
            return RankingUtil.sort(source, RANKING_ASC);
        }

        public static <T extends HasRanking> List<T> rankingDesc(Collection<T> source) {
            return RankingUtil.sort(source, RANKING_DESC);
        }

        private static <T extends HasRanking> List<T> sort(Collection<T> source, Comparator<HasRanking> comparator) {
            List list = source instanceof List ? (List)source : Lists.newArrayList(source);
            Collections.sort(list, comparator);
            return list;
        }

        private RankingUtil() {
        }
    }
}

