/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.enums.Customize;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public enum LimitType {
    LOWER("0", "\u5c0f\u5199\u5b57\u6bcd", "a-z"),
    UPPER("1", "\u5927\u5199\u5b57\u6bcd", "A-Z"),
    NUMBER("2", "\u6570\u5b57", "0-9"),
    HEART_SYMBOL("3", "\u7231\u5fc3\u8868\u60c5", "(\\[\\[love\\]\\])*", "[[love]]"),
    POINT_SYMBOL("4", "\u82f1\u6587\u70b9\u5b57\u7b26", ".", "."),
    SMILE_SYMBOL("5", "\u7b11\u8138\u8868\u60c5", "(\\[\\[smile\\]\\])*", "[[smile]]"),
    ARROW_HEART_SYMBOL("6", "\u4e00\u7bad\u7a7f\u5fc3\u8868\u60c5", "(\\[\\[arrowheart\\]\\])*", "[[arrowheart]]"),
    POINT_MIDDLE_SYMBOL("7", "\u82f1\u6587\u4e2d\u95f4\u70b9\u5b57\u7b26", "\u2022", "\u2022"),
    LB_PHONE_SYMBOL("8", "\u624b\u673a", "(\\[\\[lbphone\\]\\])*", "[[lbphone]]"),
    LB_BULB_SYMBOL("9", "\u706f\u6ce1", "(\\[\\[lbbulb\\]\\])*", "[[lbbulb]]"),
    LB_AIRPLANE_SYMBOL("10", "\u98de\u673a", "(\\[\\[lbairplane\\]\\])*", "[[lbairplane]]"),
    LB_SUNGLASSES_SYMBOL("11", "\u58a8\u955c", "(\\[\\[lbsunglasses\\]\\])*", "[[lbsunglasses]]"),
    LB_FLASH_SYMBOL("12", "\u95ea\u7535", "(\\[\\[lbflash\\]\\])*", "[[lbflash]]"),
    LB_STAR_SYMBOL("13", "\u4e94\u89d2\u661f", "(\\[\\[lbstar\\]\\])*", "[[lbstar]]"),
    LB_BICYCLE_SYMBOL("14", "\u81ea\u884c\u8f66", "(\\[\\[lbbicycle\\]\\])*", "[[lbbicycle]]"),
    LB_BOY_SYMBOL("15", "\u7537\u5b69", "(\\[\\[lbboy\\]\\])*", "[[lbboy]]"),
    LB_GIRL_SYMBOL("16", "\u5973\u5b69", "(\\[\\[lbgirl\\]\\])*", "[[lbgirl]]"),
    LB_OK_SYMBOL("17", "ok", "(\\[\\[lbok\\]\\])*", "[[lbok]]"),
    BROMEL_SYMBOL("18", "\u9cf3\u68a8", "(\\[\\[bromel\\]\\])*", "[[bromel]]"),
    ARIES_SYMBOL("21", "\u767d\u7f8a\u5ea7", "(\\[\\[aries\\]\\])*", "[[aries]]"),
    TAURUS_SYMBOL("22", "\u91d1\u725b\u5ea7", "(\\[\\[taurus\\]\\])*", "[[taurus]]"),
    GEMINI_SYMBOL("23", "\u53cc\u5b50\u5ea7", "(\\[\\[gemini\\]\\])*", "[[gemini]]"),
    CANCER_SYMBOL("24", "\u5de8\u87f9\u5ea7", "(\\[\\[cancer\\]\\])*", "[[cancer]]"),
    LEO_SYMBOL("25", "\u72ee\u5b50\u5ea7", "(\\[\\[leo\\]\\])*", "[[leo]]"),
    VIRGO_SYMBOL("26", "\u5904\u5973\u5ea7", "(\\[\\[virgo\\]\\])*", "[[virgo]]"),
    LIBRA_SYMBOL("27", "\u5929\u79e4\u5ea7", "(\\[\\[libra\\]\\])*", "[[libra]]"),
    SCORPIO_SYMBOL("28", "\u5929\u874e\u5ea7", "(\\[\\[scorpio\\]\\])*", "[[scorpio]]"),
    SAGITTARIUS_SYMBOL("29", "\u5c04\u624b\u5ea7", "(\\[\\[sagittarius\\]\\])*", "[[sagittarius]]"),
    CAPRICORN_SYMBOL("30", "\u6469\u874e\u5ea7", "(\\[\\[capricorn\\]\\])*", "[[capricorn]]"),
    AQUARIUS_SYMBOL("31", "\u6c34\u74f6\u5ea7", "(\\[\\[aquarius\\]\\])*", "[[aquarius]]"),
    PISCES_SYMBOL("32", "\u53cc\u9c7c\u5ea7", "(\\[\\[pisces\\]\\])*", "[[pisces]]");

    private String code;
    private String value;
    private String regEx;
    private String symbol;
    private static List<LimitType> basicsLimitTypes;

    private LimitType(String code, String value, String regEx) {
        this.code = code;
        this.value = value;
        this.regEx = regEx;
    }

    private LimitType(String code, String value, String regEx, String symbol) {
        this.code = code;
        this.value = value;
        this.regEx = regEx;
        this.symbol = symbol;
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public String getRegEx() {
        return this.regEx;
    }

    public static LimitType getLimitTypeByCode(String code) {
        for (LimitType value : LimitType.values()) {
            if (!StringUtils.equals((CharSequence)value.getCode(), (CharSequence)code)) continue;
            return value;
        }
        return null;
    }

    public static List<LimitType> getLimitTypeByCodes(List<String> codes) {
        if (null == codes) {
            return null;
        }
        ArrayList limitTypes = Lists.newArrayList();
        for (String code : codes) {
            LimitType limitType = LimitType.getLimitTypeByCode(code);
            if (null == limitType) continue;
            limitTypes.add(limitType);
        }
        return limitTypes;
    }

    public static String getRegEx(List<LimitType> limitTypes) {
        StringBuffer regEx = new StringBuffer();
        StringBuffer regEx1 = new StringBuffer();
        for (LimitType basicsLimitType : basicsLimitTypes) {
            if (!limitTypes.contains((Object)basicsLimitType)) continue;
            regEx1.append(basicsLimitType.getRegEx());
        }
        if (StringUtils.isNotEmpty((CharSequence)regEx1)) {
            regEx1.insert(0, "[");
            regEx1.append("]*");
        }
        regEx.append("^(");
        regEx.append(regEx1);
        for (LimitType limitType : limitTypes) {
            if (basicsLimitTypes.contains((Object)limitType)) continue;
            regEx.append(limitType.getRegEx());
        }
        regEx.append(")*$");
        return regEx.toString();
    }

    public static Integer getSymbolStrLength(String sourceStr, List<LimitType> limitTypes) {
        if (CollectionUtils.isNotEmpty(limitTypes)) {
            for (LimitType limitType : limitTypes) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{limitType.symbol})) continue;
                sourceStr = sourceStr.replace(limitType.symbol, "-");
            }
        }
        return sourceStr.length();
    }

    static {
        basicsLimitTypes = Lists.newArrayList((Object[])new LimitType[]{LOWER, UPPER, NUMBER, POINT_SYMBOL, POINT_MIDDLE_SYMBOL});
    }
}

