package com.thebeastshop.support.vo.customize;

import com.thebeastshop.support.enums.Customize.LimitType;

import java.io.Serializable;
import java.util.List;

/**
 * 输入框限制
 * Created by GFL on 2017/5/15.
 */
public class InputLimit implements Serializable {

    private static final long serialVersionUID = 1L;

    private List<LimitType> type;                      //输入文字类型限制

    private Integer maxLength;                         //最大长度限制

    private String englishFont;                        //英文字体

    private String digitalFont;                        //数字字体

    public InputLimit() {
    }

    public InputLimit(List<LimitType> types, Integer maxLength) {
        this.type = types;
        this.maxLength = maxLength;
    }

    public InputLimit(List<LimitType> types, Integer maxLength, String englishFont, String digitalFont) {
        this.type = types;
        this.maxLength = maxLength;
        this.englishFont = englishFont;
        this.digitalFont = digitalFont;
    }

    public List<LimitType> getType() {
        return type;
    }

    public void setType(List<LimitType> type) {
        this.type = type;
    }

    public Integer getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public String getEnglishFont() {
        return englishFont;
    }

    public void setEnglishFont(String englishFont) {
        this.englishFont = englishFont;
    }

    public String getDigitalFont() {
        return digitalFont;
    }

    public void setDigitalFont(String digitalFont) {
        this.digitalFont = digitalFont;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("InputLimit{");
        sb.append("type=").append(type);
        sb.append(", maxLength=").append(maxLength);
        sb.append(", englishFont='").append(englishFont).append('\'');
        sb.append(", digitalFont='").append(digitalFont).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
