package com.thebeastshop.support.vo.campaign;

import com.google.common.collect.Lists;
import com.thebeastshop.support.vo.pack.GiftPackVO;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * @description: 赠品区间
 * @author: Xiang.Gao
 * @create: 2019-12-19
 **/
public class CampaignSectionVO {

    private static final long serialVersionUID = 1L;

    /**
     * 阶梯ID
     */
    private Long id;

    /**
     * 阶梯名称
     */
    private String name;

    /**
     * 阶梯最大可选次数
     */
    private Integer maximun;

    /**
     * 是否已满足
     */
    private Boolean satisfied = false;

    /**
     * 提示语
     */
    private String prompt;

    /**
     * 是否已获得
     */
    private Boolean owned = false;

    /**
     * 赠品包
     */
    private List<SectionProductVO> products = Lists.newArrayList();

    /**
     * 排序
     */
    private Float sort;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMaximun() {
        return maximun;
    }

    public void setMaximun(Integer maximun) {
        this.maximun = maximun;
    }

    public Boolean getSatisfied() {
        return satisfied;
    }

    public void setSatisfied(Boolean satisfied) {
        this.satisfied = satisfied;
    }

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Boolean getOwned() {
        return owned;
    }

    public void setOwned(Boolean owned) {
        this.owned = owned;
    }

    public List<SectionProductVO> getProducts() {
        return products;
    }

    public void setProducts(List<SectionProductVO> products) {
        this.products = products;
    }

    public Float getSort() {
        return sort;
    }

    public void setSort(Float sort) {
        this.sort = sort;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
