package com.thebeastshop.support.vo;

import java.util.ArrayList;
import java.util.List;

public class ArticleVo {

	private Integer id;
	private String title = "";
	private Share share = new Share();
	private List<Module> modules = new ArrayList<Module>();

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Share getShare() {
		return share;
	}

	public void setShare(Share share) {
		this.share = share;
	}

	public List<Module> getModules() {
		return modules;
	}

	public void setModules(List<Module> modules) {
		this.modules = modules;
	}

	public static class Share {
		private String image = "";
		private String link = "";
		private String title = "";
		private String content = "";

		public String getImage() {
			return image;
		}

		public void setImage(String image) {
			this.image = image;
		}

		public String getLink() {
			return link;
		}

		public void setLink(String link) {
			this.link = link;
		}

		public String getTitle() {
			return title;
		}

		public void setTitle(String title) {
			this.title = title;
		}

		public String getContent() {
			return content;
		}

		public void setContent(String content) {
			this.content = content;
		}
	}

	public static class Base {

	}

	public static class Image extends Base {
		private String src;
		private String link;
		private Boolean isHeader;

		public String getSrc() {
			return src;
		}

		public void setSrc(String src) {
			this.src = src;
		}

		public String getLink() {
			return link;
		}

		public void setLink(String link) {
			this.link = link;
		}

		public Boolean getIsHeader() {
			return isHeader;
		}

		public void setIsHeader(Boolean isHeader) {
			this.isHeader = isHeader;
		}

	}

	public static class Preface extends Base {
		private String title;
		private String content;

		public String getTitle() {
			return title;
		}

		public void setTitle(String title) {
			this.title = title;
		}

		public String getContent() {
			return content;
		}

		public void setContent(String content) {
			this.content = content;
		}
	}

	public static class Video extends Base {
		private String src;
		private String isHeader;

		public String getSrc() {
			return src;
		}

		public void setSrc(String src) {
			this.src = src;
		}

		public String getIsHeader() {
			return isHeader;
		}

		public void setIsHeader(String isHeader) {
			this.isHeader = isHeader;
		}
	}

	public static class Product extends Base {
		private Integer id;
		private String product;

		public Integer getId() {
			return id;
		}

		public void setId(Integer id) {
			this.id = id;
		}

		public String getProduct() {
			return product;
		}

		public void setProduct(String product) {
			this.product = product;
		}
	}

	public static class Text extends Base {
		private String title;
		private String content;

		public String getTitle() {
			return title;
		}

		public void setTitle(String title) {
			this.title = title;
		}

		public String getContent() {
			return content;
		}

		public void setContent(String content) {
			this.content = content;
		}
	}

	public static class FlavoredModule {
		private Object product;
		private String featureImage;

		public FlavoredModule() {
			super();
		}

		public FlavoredModule(Object product, String featureImage) {
			super();
			this.product = product;
			this.featureImage = featureImage;
		}

		public Object getProduct() {
			return product;
		}

		public void setProduct(Object product) {
			this.product = product;
		}

		public String getFeatureImage() {
			return featureImage;
		}

		public void setFeatureImage(String featureImage) {
			this.featureImage = featureImage;
		}

	}
}
